var cl = {
    url: null,
    ssn: SnackBar,
    location: {
        data: {
            latitude: null,
            longitude: null,
            altitude: null,
            accuracy: null,
            altitudeAccuracy: null,
            heading: null,
            speed: null,
            timestamp: null
        },
        locationSuccess: (position) => {
            cl.location.data.longitude = position.coords.longitude
            cl.location.data.latitude = position.coords.latitude
            cl.location.data.altitude = position.coords.altitude
            cl.location.data.accuracy = position.coords.accuracy
            cl.location.data.altitudeAccuracy = position.coords.altitudeAccuracy
            cl.location.data.heading = position.coords.height
            cl.location.data.speed = position.coords.speed
            cl.location.data.timestamp = position.timestamp
            console.log('position', cl.location.data)
        },
        locationError: (error) => {
            const code = error.code;
            const message = error.message;
            navigator.permissions.query({name: 'geolocation'}).then(console.log)
            console.log(code, message)
        },
        get: () => {
            navigator.geolocation.getCurrentPosition(cl.location.locationSuccess, cl.location.locationError);
        }
    },
    init: () => {
        console.log('init uolli')
        // cl.location.get()
        cl.clientFingerprint()
        cl.fornAuth()
        cl.validateRetryPassword()
        cl.applyMask()
    },
    clientFingerprint: () => {
        // Create a new ClientJS object
        const client = new ClientJS();
        const fingerprint = client.getCustomFingerprint();
        const x = document.getElementsByName("deviceFingerprint");
        var i;
        for (i = 0; i < x.length; i++) {
            if (x[i].type == "hidden") {
                x[i].value = fingerprint;
            }
        }
    },
    dd: (id) => {
        return document.querySelectorAll(id)
    },
    $: (id) => {
        return document.getElementById(id)
    },
    fornAuth: () => {
        var accLogin = cl.dd('.accLogin')
        accLogin.forEach(function (item, index) {
            item.addEventListener('click', function (event) {
                var accFormLogin = cl.dd('.accFormLogin')
                accFormLogin.forEach(function (e, i) {
                    // e.style.display = 'none'
                    e.classList.add("d-none");
                })
                event.preventDefault()
                const form = item.getAttribute("data-form")
                const elform = cl.$(form)
                if (elform !== null) {
                    //cl.$(form).style.display = 'inline'
                    cl.$(form).classList.remove("d-none");
                }
            })
        })
    },
    validateRetryPassword: () => {
        var formRecovery = cl.$('form-recovery')
        if (formRecovery !== null) {
            formRecovery.addEventListener('submit', function (event) {
                event.preventDefault()
                const pass1 = cl.$('acc_pass').value
                const pass2 = cl.$('retry_acc_pass').value
                if (pass1 !== pass2) {
                    cl.sn('As senhas não são iguais! repita a operação', 'warning')
                } else if (pass1.length < 8) {
                    cl.sn('Senha muito curta, tente com uma senha maior', 'warning')
                } else {
                    formRecovery.submit()
                }
            }, true)
        }
    },
    applyMask: () => {
        const arr = document.querySelectorAll("input[data-mask]");
        for (var i = 0; i < arr.length; i++) {
            var maskOptions = {
                mask: arr[i].getAttribute('data-mask')
            };
            var mask = IMask(arr[i], maskOptions)
        }
    },
    sn: function (msg, style) {
        cl.ssn({
            message: msg,
            status: style,
            timeout: 5000,
            width: "80vw",
            speed: 500,
            fixed: true,
            position: "tc"
        })
    }
}

