const app = {
    ws: null,
    status: false,
    config: {
        host: 'localhost',
        port: 9002,
        pin: ''
    },
    acao: [
        { key: 'PS', value: 'PASSAGEM LIBERADA' },
        { key: 'CI', value: 'TICKET INVÁLIDO' },
        { key: 'CB', value: 'TICKET BLOQUEADO' },
        { key: 'CR', value: 'TICKET REGISTRADO' },
        { key: 'CE', value: 'EVENTO EXPIRADO' },
        { key: 'CN', value: '..FALHA CONEXÃO..' },
        { key: 'CS', value: '..FALHA SOCKET..' }
    ],
    init: (ws) => {
        app.load()
        app.ws = ws
        app.$('btn-save').addEventListener('click', function (event) {
            app.config.host = app.$('host').value
            app.config.port = app.$('port').value
            app.config.pin = app.$('pin').value
            app.save()
            app.sendLogin()
          })
        app.$('main').addEventListener('click', function (event) {
            app.$('card').focus()
        })
        app.$('card').addEventListener("keypress", function (event) {
            if (event.key === "Enter") {
                app.validate(this.value)
                this.select()
                event.preventDefault();
            }
        });
    },
    load: () => {
        const obj = app.storage.load('settings')
        if (obj != null) {
            app.config.host = obj.host
            app.config.port = obj.port
            app.config.pin = obj.pin
        }
        app.$('host').value = app.config.host
        app.$('port').value = app.config.port
        app.$('pin').value = app.config.pin
    },
    save: () => {
        app.storage.save('settings', app.config)
        app.load()
    },
    dd: (id) => {
        return document.querySelectorAll(id)
    },
    $: (id) => {
        return document.getElementById(id)
    },
    connect: () => {
        app.ws.init(app.config.host, app.config.port, false, (data) => {
            console.log('connected...', data)
            app.$('footer').classList.remove("bg-danger")
            app.$('footer').classList.remove("bg-success")
            if (data.conn === false) {
                app.$('connect-status').innerHTML = '...Não conectado...'
                app.$('footer').classList.add("bg-danger")
            } else {
                app.$('connect-status').innerHTML = '...conectado...'
                app.$('footer').classList.add("bg-success")
                app.sendLogin()
            }
        });
    },
    sendLogin: () => {
        let params = { pin: app.config.pin }
        app.ws.sendData('AUTH.LOGIN', params, (data) => {
            if(data.status === false) {
                app.$('connect-status').innerHTML = data.message
                app.$('footer').classList.add("bg-danger")
            } else if (data.result === null) {
                app.$('connect-status').innerHTML = data.message
                app.$('data_3').innerHTML = data.message
                app.$('footer').classList.add("bg-danger")
            } else {
                app.$('connect-status').innerHTML = data.terminal_nome
                app.$('data_3').innerHTML = ''
                app.$('footer').classList.add("bg-success")
            }
            console.log('login', data)
        });
    },
    validate: (card) => {
        app.$('card').innerHTML = ''
        app.$('foto').src = ''
        app.$('data_3').innerHTML = ''
        let params = { card }
        app.ws.sendData('VALIDATE', params, function (data) {
            const index = app.acao.findIndex(aa => aa.key === data.saida)
            app.$('data_1').innerHTML = data.nome
            if (index !== -1) {
                app.$('data_2').innerHTML = app.acao[index].value
            }
            if (data.saida == 'PS') {
                app.$('data_1').classList.remove('bg-warning');
                app.$('data_1').classList.remove('bg-danger');
                app.$('data_1').classList.add('bg-success');
            } else if (data.saida == 'CR') {
                app.$('data_1').classList.remove('bg-warning');
                app.$('data_1').classList.remove('bg-success');
                app.$('data_1').classList.add('bg-danger');
                const date = data.hora_acesso
                const readable_date = new Date(date).toLocaleString("pt-BR", {timeZone: 'America/Sao_Paulo'});   
                console.log(readable_date);
                app.$('data_2').innerHTML = "Registro em " + readable_date;
            } else {
                app.$('data_1').classList.remove('bg-warning');
                app.$('data_1').classList.remove('bg-success');
                app.$('data_1').classList.add('bg-danger');
            }
            // app.$('card').innerHTML = data.nome
            if(data.image === null) {
                app.$('foto').src = app.person
            } else {
                app.$('foto').src = data.image
            }
            
            app.$('data_3').innerHTML = data.categoria
        });
    },
    storage: {
        load: (name) => {
            const rawValue = localStorage.getItem(name)
            if (app.storage.isJson(rawValue)) {
                return JSON.parse(rawValue)
            } else {
                return { rawValue }
            }
        },
        save: (name, obj) => {
            localStorage.setItem(name, JSON.stringify(obj))
        },
        delete: (name) => {
            localStorage.removeItem(name)
        },
        isJson: function (str) {
            try {
                JSON.parse(str)
            } catch (e) {
                return false
            }
            return true
        }
    },
    person: 'data:image/jpeg;base64,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'

}