<?php $this->extend('layout/app'); ?>

<?php $this->section('header'); ?>
<title>Usuário</title>
<?php $this->endsection(); ?>
<?php $this->section('main'); ?>

<form class="form-validate" method="post" action="<?php echo base_url() . '/user' . (!empty($usuario->id) ? "/{$usuario->id}" : ""); ?>" id="form-user">
    <div class="row g-4">
        <!-- side -->
        <div class="">
            <div class="section">
                <div class="h5 card-header border-bottom-0 fw-bold">Usuário</div>
                <div class="card-body">
                    <div class="row g-3 mb-3">
                        <div class="col-lg-6">
                            <div class="form-floating">
                                <input required type="text" class="form-control" id="nome_completo" name="nome_completo" placeholder="Usuário" value="<?php echo $usuario->nome_completo;?>">
                                <label for="usuario">Nome do usuário</label>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="form-floating">
                                <input required type="text" class="form-control" id="login" name="login" placeholder="Login" value="<?php echo $usuario->login;?>">
                                <label for="login">Login</label>
                            </div>
                        </div>
                    </div>
                    <div class="row g-3 mb-3">
                        <div class="col-lg-6">
                            <div class="form-floating">
                                <input type="password" class="form-control" id="pass" name="pass" placeholder="Digite a senha" value="">
                                <label for="data_inicio">Senha</label>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="form-floating">
                                <input type="password" class="form-control" id="pass2" name="pass2" placeholder="Repita a senha" value="">
                                <label for="data_fim">Repetir a senha</label>
                            </div>
                        </div>
                    </div>
                    <div class="row g-3 mb-3">
                        <div class="col-lg-4">
                            <label class="d-flex align-items-center mb-3">
                                <input class="d-none-cloaked" type="checkbox" name="ativo" id="ativo" value="1" <?php echo $usuario->ativo=='Y'?'checked=""':'';?>>
                                <i class="switch-icon switch-icon-primary switch-icon-xs"></i>
                                <span class="px-3 user-select-none">Usuário ativo?</span>
                            </label>
                        </div>
                        <div class="col-lg-4">
                            <label class="d-flex align-items-center mb-3">
                                <input class="d-none-cloaked" type="checkbox" name="Ncadastro" id="Ncadastro" value="1" <?php echo $usuario->Ncadastro=='1'?'checked=""':'';?>>
                                <i class="switch-icon switch-icon-primary switch-icon-xs"></i>
                                <span class="px-3 user-select-none">Permite Credenciamento?</span>
                            </label>
                        </div>
                        <div class="col-lg-4">
                            <label class="d-flex align-items-center mb-3">
                                <input class="d-none-cloaked" type="checkbox" name="Nadm" id="Nadm" value="1" <?php echo $usuario->Nadm=='1'?'checked=""':'';?>>
                                <i class="switch-icon switch-icon-primary switch-icon-xs"></i>
                                <span class="px-3 user-select-none">Administrador?</span>
                            </label>
                        </div>
                    </div>
                </div>
                <div class="card-footer border-light">
                    <a href="<?php echo base_url(); ?>/user" class="btn btn-secondary">
                        <i class="fi fi-arrow-left"></i>
                        <span>Voltar</span>
                    </a>
                    <button type="submit" class="btn btn-primary">
                        <svg width="18px" height="18px" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <polyline points="20 6 9 17 4 12"></polyline>
                        </svg>
                        <span><?php echo $usuario->id?'Salvar':'Criar usuario'; ?></span>
                    </button>
                </div>
            </div>
        </div>
    </div>
</form>
<?php $this->endsection(); ?>