<?php $this->extend('layout/app'); ?>

<?php $this->section('header'); ?>
<title>Tickets</title>
<?php $this->endsection(); ?>
<?php $this->section('main'); ?>

<!-- user list -->
<div class="section p-0">
    <div class="card-header p-4">

        <div class="row g-3">

            <!-- review filter -->
            <div class="order-2 order-md-1 col">
                <div class="w-100">
                    <h2 class="h5 mb-0">Cadastro de Tickets</h2>
                </div>
            </div>

            <!-- options -->
            <div class="order-1 order-md-2 col-md-auto">
                <a href="<?php echo base_url() . '/ticket/add'; ?>" class="w-100 btn btn-sm btn-primary">
                    <svg width="18px" height="18px" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <line x1="12" y1="5" x2="12" y2="19"></line>
                        <line x1="5" y1="12" x2="19" y2="12"></line>
                    </svg>
                    <span>Novo Ticket</span>
                </a>
            </div>

        </div>

    </div>

    <div class="card-body pt-1">

        <!-- item list -->
        <div class="table-responsive-md">
            <div class="row align-items-start my-4">
                <div class="order-1 order-md-2 col-md-auto">
                    <label for="filter-event" class="form-label">Evento</label>
                    <select class="form-select form-select-sm filters" id="filter-event" name="event">
                        <option value="" selected>Todos</option>
                        <?php foreach ($events as $e) : ?>
                            <option value="<?php echo $e->id; ?>"><?php echo $e->evento; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="order-1 order-md-2 col-md-auto">
                    <label for="filter-category" class="form-label">Categoria</label>
                    <select class="form-select form-select-sm filters" id="filter-category" name="category">
                        <option value="" selected>Todos</option>
                        <?php foreach ($categories as $ca) : ?>
                            <option value="<?php echo $ca->id; ?>"><?php echo $ca->categoria; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="order-1 order-md-2 col-md-auto">
                    <label for="filter-status" class="form-label">Status</label>
                    <select class="form-select form-select-sm filters" id="filter-status" name="status">
                        <option value="" selected>Todos</option>
                        <option value="1">Ativo</option>
                        <option value="0">Bloqueado</option>
                    </select>
                </div>
            </div>

            <table class="table datatable table-bordered table-hover table-striped" id="datatable" role="grid" aria-describedby="mobile-page-info">
                <thead>
                    <tr>
                        <th style="width:46px">
                            <div class="form-check">
                                ID
                            </div>
                        </th>
                        <th class="small text-muted">TICKET</th>
                        <th class="small text-muted">EVENTO / CATEGORIA</th>
                        <th class="small text-muted">STATUS</th>
                        <th class="small text-muted">ATIVIDADE</th>
                        <th class="small text-muted">IMAGE</th>
                        <th class="small text-muted">
                            <!-- options -->
                        </th>
                    </tr>
                </thead>
                <tbody>
                </tbody>
            </table>
        </div>
    </div>
</div>
<!-- /widgets -->
<?php $this->endsection(); ?>
<?php $this->section('scripts'); ?>
<script src="<?php echo base_url(); ?>/assets/js/vendor.datatables.js"></script>
<script>
    $(document).ready(function() {
        $('.filters').change(function() {
            $('#datatable').DataTable().ajax.reload();
        });


        var table = $('#datatable').dataTable({
            processing: true,
            serverSide: true,
            pageLength: 10,
            searchDelay: 600,
            order: [
                [0, "desc"],
                [1, "asc"]
            ],
            ajax: {
                "url": "<?php echo base_url(); ?>/ticket/data",
                "data": function(d) {
                    var event = $('#filter-event').val();
                    var category = $('#filter-category').val();
                    var status = $('#filter-status').val();
                    return $.extend({}, d, {
                        status: status,
                        category: category,
                        event: event,
                    });
                }
            },
            loadingMessage: 'Carregando...',
            dom: '<"toolbar">frtip',
            class: 'pagination',
            columnDefs: [{
                responsivePriority: 1,
                targets: 0
            }],
            language: {
                emptyTable: "Nenhum registro destaqueizado.",
                info: "Exibindo _START_ até _END_ de _TOTAL_ registros",
                infoEmpty: "Exibindo 0 até 0 de 0 registros",
                infoFiltered: "(filtrados de _MAX_ no total)",
                infoPostFix: "",
                thousands: ",",
                lengthMenu: "Exibindo _MENU_ registros",
                loadingRecords: "Carregando...",
                processing: "Processando...",
                search: "Busca:",
                zeroRecords: "Nenhum registro destaqueizado.",
                paginate: {
                    first: "Primeiro",
                    last: "Ultimo",
                    next: "Prox.",
                    previous: "Ant."
                },
                aria: {
                    sortAscending: ": activate to sort column ascending",
                    sortDescending: ": activate to sort column descending"
                }
            }
        });
    });
</script>

<?php $this->endsection(); ?>