<?php $this->extend('layout/app'); ?>

<?php $this->section('header'); ?>
<title>Ticket</title>
<?php $this->endsection(); ?>
<?php $this->section('main'); ?>

<form class="form-validate" method="post" action="<?php echo base_url() . '/ticket' . (!empty($ticket->id) ? "/{$ticket->id}" : ""); ?>" id="form-ticket">
    <div class="row g-4">
        <!-- side -->
        <div class="">
            <div class="section">
                <div class="h5 card-header border-bottom-0 fw-bold">Ticket</div>
                <div class="card-body">
                    <div class="row g-3 mb-3">
                        <div class="col-lg-8">
                            <div class="row g-3 mb-3">
                                <div class="col-lg-6">
                                    <div class="form-floating">
                                        <select class="form-select form-select-sm filters" id="filter-event" name="id_evento">
                                            <?php foreach ($events as $e) : ?>
                                                <option value="<?php echo $e->id; ?>" <?php echo $e->id == $ticket->id_evento ? "selected" : ""; ?>><?php echo $e->evento; ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                        <label for="filter-event" class="form-label">Evento</label>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-floating">
                                        <select class="form-select form-select-sm filters" id="filter-category" name="id_categoria">
                                            <?php foreach ($categories as $ca) : ?>
                                                <option value="<?php echo $ca->id; ?>" <?php echo $ca->id == $ticket->id_categoria ? "selected" : ""; ?>><?php echo $ca->categoria; ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                        <label for="filter-category" class="form-label">Categoria</label>
                                    </div>
                                </div>
                            </div>
                            <div class="row g-3 mb-3">
                                <div class="col-lg-4">
                                    <div class="form-floating">
                                        <input required type="text" class="form-control" id="cartao" name="cartao" data-ticket-id="<?php echo $ticket->id; ?>" placeholder="Ticket" value="<?php echo $ticket->cartao; ?>">
                                        <label for="usuario">Cod do Ticket</label>
                                    </div>
                                </div>
                                <div class="col-lg-8">
                                    <div class="form-floating">
                                        <input type="text" class="form-control" id="nome" name="nome" placeholder="Nome" value="<?php echo $ticket->nome; ?>">
                                        <label for="login">Nome</label>
                                    </div>
                                </div>
                            </div>
                            <div class="row g-3 mb-3">
                                <div class="col-lg-4">
                                    <div class="form-floating">
                                        <input type="text" class="form-control" id="email" name="email" placeholder="e-mail" value="<?php echo $ticket->email; ?>">
                                        <label for="usuario">e-mail</label>
                                    </div>
                                </div>
                                <div class="col-lg-4">
                                    <div class="form-floating">
                                        <input type="text" class="form-control" id="rg" name="rg" placeholder="RG" value="<?php echo $ticket->rg; ?>">
                                        <label for="usuario">RG</label>
                                    </div>
                                </div>
                                <div class="col-lg-4">
                                    <div class="form-floating">
                                        <input type="text" class="form-control" id="cpf" name="cpf" placeholder="CPF" value="<?php echo $ticket->cpf; ?>">
                                        <label for="usuario">CPF</label>
                                    </div>
                                </div>
                            </div>
                            <div class="row g-3 mb-3">
                                <div class="col-lg-4">
                                    <div class="form-floating">
                                        <input type="text" class="form-control" id="campoextra1" name="campoextra1" placeholder="Campo Extra 1" value="<?php echo $ticket->campoextra1; ?>">
                                        <label for="usuario">Campo Extra 1</label>
                                    </div>
                                </div>
                                <div class="col-lg-4">
                                    <div class="form-floating">
                                        <input type="text" class="form-control" id="campoextra2" name="campoextra2" placeholder="Campo Extra 2" value="<?php echo $ticket->campoextra2; ?>">
                                        <label for="usuario">Campo Extra 2</label>
                                    </div>
                                </div>
                                <div class="col-lg-4">
                                    <div class="form-control">
                                        <label class="d-flex align-items-center mb-1">
                                            <input class="d-none-cloaked" type="checkbox" name="mestre" id="mestre" value="1" <?php echo $ticket->mestre == '1' ? 'checked=""' : ''; ?>>
                                            <i class="switch-icon switch-icon-primary switch-icon-xs"></i>
                                            <span class="px-3 user-select-none">Cartão Mestre</span>
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <div class="row g-3 mb-3">
                                <div class="col-lg-4">
                                    <div class="form-control">
                                        <label class="d-flex align-items-center mb-1">
                                            <input class="d-none-cloaked" type="checkbox" name="situacao" id="situacao" value="1" <?php echo $ticket->situacao == '1' ? 'checked=""' : ''; ?>>
                                            <i class="switch-icon switch-icon-primary switch-icon-xs"></i>
                                            <span class="px-3 user-select-none">Ticket Ativo</span>
                                        </label>
                                    </div>
                                </div>
                                <div class="col-lg-8">
                                    <div class="form-control">
                                        <?php echo !empty($ticket->ticketeira_id) ? "Ticketeira: {$ticket->ticketeira_id}  " : ''; ?>
                                        <?php echo !empty($ticket->ticketeira_identify) ? "Ticketeira ID: {$ticket->ticketeira_identify}  " : ''; ?>
                                    </div>
                                </div>
                            </div>
                            <div class="row g-3 mb-3">
                                <div class="col">
                                    <a href="<?php echo base_url(); ?>/ticket" class="btn btn-secondary">
                                        <i class="fi fi-arrow-left"></i>
                                        <span>Voltar</span>
                                    </a>
                                    <button type="submit" class="btn btn-primary">
                                        <svg width="18px" height="18px" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                            <polyline points="20 6 9 17 4 12"></polyline>
                                        </svg>
                                        <span><?php echo $ticket->id ? 'Salvar' : 'Criar ticket'; ?></span>
                                    </button>
                                    <?php if ($ticket->id) { ?>
                                        <button type="button" id="btn-remove" class="btn btn-danger">
                                            <svg width="18px" height="18px" xmlns="http://www.w3.org/2000/svg" fill="currentColor" class="bi bi-x-circle" viewBox="0 0 16 16">
                                                <path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14zm0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16z"></path>
                                                <path d="M4.646 4.646a.5.5 0 0 1 .708 0L8 7.293l2.646-2.647a.5.5 0 0 1 .708.708L8.707 8l2.647 2.646a.5.5 0 0 1-.708.708L8 8.707l-2.646 2.647a.5.5 0 0 1-.708-.708L7.293 8 4.646 5.354a.5.5 0 0 1 0-.708z"></path>
                                            </svg>
                                            <span>Excluir</span>
                                        </button>
                                    <?php  } ?>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4">
                            <div class="me-4 d-none d-md-block">
                                <img id="photo" class="img-fluid bg-suprime opacity-9 img-thumbnail" src="<?php echo base_url(); ?>/assets/images/person.jpg" alt="...">
                            </div>
                            <table class="table-datatable table table-bordered table-hover table-striped" data-lng-empty="Sem registro de marcações" data-lng-page-info="Exibindo _START_ até _END_ de _TOTAL" data-lng-filtered="(filtered from _MAX_ total entries)" data-lng-loading="Loading..." data-lng-processing="Processing..." data-lng-search="Search..." data-lng-norecords="No matching records found" data-lng-sort-ascending=": activate to sort column ascending" data-lng-sort-descending=": activate to sort column descending" data-main-search="false" data-column-search="false" data-row-reorder="false" data-col-reorder="false" data-responsive="true" data-header-fixed="true" data-select-onclick="false" data-enable-paging="true" data-enable-col-sorting="false" data-autofill="false" data-group="false" data-items-per-page="4" data-enable-column-visibility="false" data-lng-column-visibility="Column Visibility" data-enable-export="false" data-export-pdf-disable-mobile="false" data-custom-config='{}'>
                                <thead>
                                    <tr>
                                        <th>Data/Hora</th>
                                        <th>Status</th>
                                        <th>Giro</th>
                                        <th>Terminal</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($registry as $m) : ?>
                                        <?php
                                        $nk = array_key_exists($m->acao, $acts) ? $m->acao : 'CI';
                                        ?>
                                        <tr class="bg-<?php echo $acts[$nk]->style; ?>">
                                            <td><?php echo date('d/m/Y H:i:s', strtotime($m->data_acesso)); ?></td>
                                            <td><?php echo $acts[$nk]->info; ?></td>
                                            <td><?php echo $m->giro; ?></td>
                                            <td><?php echo $m->terminal_nome; ?></td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>
<div class="modal fade" id="modalRemove" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabelSm" aria-hidden="true">
    <div class="modal-dialog modal-sm" role="document">
        <div class="modal-content">

            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabelSm">Remover Registro</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>

            <div class="modal-body">
                Confirma a exclusão deste registro? confirmando, esta operação não poderá ser desfeita!
            </div>

            <div class="modal-footer">
                <button type="button" id="act-remove" class="btn btn-sm btn-warning">
                    <i class="fi fi-check"></i>
                    Confirmar
                </button>
                <button type="button" class="btn btn-sm btn-secondary" data-bs-dismiss="modal">
                    <i class="fi fi-close"></i>
                    Fechar
                </button>

            </div>

        </div>
    </div>
</div>
<?php $this->endsection(); ?>
<?php $this->section('scripts'); ?>
<script src="<?php echo base_url(); ?>/assets/js/vendor.datatables.js"></script>
<script>
    $(document).ready(function() {
        let idTicket = $('#cartao').data('ticket-id')
        console.log('ticket', idTicket)
        $.get('<?php echo base_url(); ?>/ticket/' + idTicket + '/photo', (data) => {
            $("#photo").attr('src', data.image)
        })
        $("#btn-remove").click(() => {
            $('#modalRemove').modal('show')
        })
        <?php if ($ticket->id) { ?>
            $("#act-remove").click(() => {
                window.location.href = '<?php echo base_url(); ?>/ticket/delete/<?php echo $ticket->id; ?>'
            })
        <?php } ?>
    })
</script>
<?php $this->endsection(); ?>