<?php $this->extend('layout/app'); ?>

<?php $this->section('header'); ?>
<title>Configurar Sync</title>
<?php $this->endsection(); ?>
<?php $this->section('main'); ?>

<?php
$attributes = ['class' => 'form-validate', 'id' => 'form-import'];
echo  form_open_multipart('manage/sync', $attributes); ?>
<div class="row g-4">
    <!-- side -->
    <div class="">
        <div class="section">
            <div class="h5 card-header border-bottom-0 fw-bold">Sync</div>
            <div class="card-body">
                <div class="section p-4 mb-2">
                    <div class="row g-3 align-items-center">
                        <div class="col">
                            <h4 class="mb-0"># Evento: <span id="event_id"></span></h4>
                            <ul class="list-unstyled m-0 p-0">
                                <li class="list-item">
                                    <span class="text-muted small" id="last_response"></span>
                                </li>
                                <li class="list-item">
                                    <div id="b-online" class="badge bg-success-soft rounded-pill">
                                        <span class="bull bull-lg bg-success me-2 animate-pulse-success"></span>
                                        <span>On Line</span>
                                    </div>
                                    <div id="b-offline" class="badge bg-danger-soft rounded-pill">
                                        <span class="bull bull-lg bg-danger me-2 animate-pulse-danger"></span>
                                        <span>Off line</span>
                                    </div>
                                </li>
                            </ul>

                        </div>
                    </div>
                </div>
            </div>
            <div class="card-footer border-light">
                <button type="submit" class="btn btn-primary">
                    <svg width="18px" height="18px" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <polyline points="20 6 9 17 4 12"></polyline>
                    </svg>
                    <span>Parar</span>
                </button>
                <a href="<?php echo base_url(); ?>/manager/startsync" target="_BLANK_" class="btn btn-secondary">
                    <i class="fi fi-database"></i>
                    <span>Iniciar sync</span>
                </a>
                <button type="button" onclick="getAllData()">getAllData</button>
            </div>
        </div>
    </div>
</div>
</form>
<?php $this->endsection(); ?>
<?php $this->section('scripts'); ?>
<script>
    const dataSync = {
        event: {
            timer: null,
            process: false,
            sync: 0,
            status: null
        },
        register: null,
        image: null
    }

    $(document).ready(function() {
        init()
        $("#b-online").hide();
        $("#b-offline").show();
        function init() {
            processa()
        }
    })

    const processa = () => {
        $("#b-online").show();
        $("#b-offline").hide();
        console.log('processa')
        
        dataSync.event.timer = setInterval(() => {
            console.log('.....')
            
            if(!dataSync.event.process) {
                getAll()
            }
        }, 5000);
    }

    const getAll = ()=> {
        dataSync.event.process = true
        dataSync.event.status = 'Escrevendo atualizações'
        $.get('<?php echo base_url(); ?>/manage/syncevent', (response) => {
            dataSync.event.process = false
            dataSync.event.status = 'Atualizado'
            console.log('update evento', response)
        });
    }

</script>
<?php $this->endsection(); ?>