<?php $this->extend('layout/app'); ?>

<?php $this->section('header'); ?>
<title>Exportar Ticket</title>
<?php $this->endsection(); ?>
<?php $this->section('main'); ?>

<form class="form-validate" method="post" action="<?php echo base_url() . '/manage/export'; ?>" id="form-generate">
    <div class="row g-4">
        <!-- side -->
        <div class="">
            <div class="section">
                <div class="h5 card-header border-bottom-0 fw-bold">Exportar Tickets</div>
                <div class="card-body">
                    <div class="table-responsive-md">
                        <div class="row g-3 mb-3">
                            <div class="col-lg-6">
                                <div class="btn btn-primary">
                                    Tickets importados <span class="badge bg-danger"><?php echo (int) $count; ?></span>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="btn btn-warning">
                                    Erros <span class="badge bg-dark"><?php echo (int) count($ticketExceptions); ?></span>
                                </div>
                            </div>
                        </div>
                        <h4>Tickets com erros:</h4>
                        <!-- <table class="table table-align-middle" role="grid" aria-describedby="mobile-page-info"> -->
                        <table class="table-datatable table table-bordered table-hover table-striped" data-lng-empty="No data available in table" data-lng-page-info="Exibindo _START_ até _END_ de _TOTAL_ " data-lng-filtered="(Filtrado _MAX_ total)" data-lng-loading="Aguarde..." data-lng-processing="Processando..." data-lng-search="Busca..." data-lng-norecords="No matching records found" data-lng-sort-ascending=": activate to sort column ascending" data-lng-sort-descending=": activate to sort column descending" data-main-search="true" data-column-search="false" data-row-reorder="false" data-col-reorder="true" data-responsive="true" data-header-fixed="false" data-select-onclick="true" data-enable-paging="true" data-enable-col-sorting="true" data-autofill="false" data-group="false" data-items-per-page="10" data-enable-column-visibility="true" data-lng-column-visibility="Column Visibility" data-enable-export="true" data-lng-export="<i class='fi fi-squared-dots fs-5 lh-1'></i>" data-lng-csv="CSV" data-lng-pdf="PDF" data-lng-xls="XLS" data-lng-copy="Copy" data-lng-print="Print" data-lng-all="All" data-export-pdf-disable-mobile="true" data-export='["csv", "pdf", "xls"]' data-options='["copy", "print"]' data-custom-config='{}'>
                            <thead>
                                <tr>
                                    <th>Ticket</th>
                                    <th class="small text-muted">Nome</th>
                                    <th class="small text-muted">Email</th>
                                    <th class="small text-muted">RG</th>
                                    <th class="small text-muted">CPF</th>
                                    <th class="small text-muted">Campo Extra1</th>
                                    <th class="small text-muted">Campo Extra2</th>
                                    <th class="small text-muted">Status</th>
                                    <th class="small text-muted">Mestre</th>
                                    <th class="small text-muted">Error</th>
                                </tr>
                            </thead>
                            <tbody id="checkall-list">

                                <!-- item -->
                                <?php foreach ($ticketExceptions as $k => $ticket) :
                                    $ticket = (object)$ticket ?>
                                    <tr>
                                        <th>
                                            <span class="d-block text-muted small"><?php echo $ticket->cartao; ?></span>
                                        </th>
                                        <td>
                                            <span class="d-block text-muted small"><?php echo $ticket->nome; ?></span>
                                        </td>
                                        <td>
                                            <span class="d-block text-muted small"><?php echo $ticket->email; ?></span>
                                        </td>
                                        <td>
                                            <span class="d-block text-muted small"><?php echo $ticket->rg; ?></span>
                                        </td>
                                        <td>
                                            <span class="d-block text-muted small"><?php echo $ticket->cpf; ?></span>
                                        </td>
                                        <td>
                                            <span class="d-block text-muted small"><?php echo $ticket->campoextra1; ?></span>
                                        </td>
                                        <td>
                                            <span class="d-block text-muted small"><?php echo $ticket->campoextra2; ?></span>
                                        </td>
                                        <td>
                                            <span class="d-flex align-items-center"><i class="fi <?php echo $ticket->situacao == '1' ? 'fi-check' : 'fi-close'; ?>"></i></span>
                                        </td>
                                        <td>
                                            <span class="d-flex align-items-center"><i class="fi <?php echo $ticket->mestre == '1' ? 'fi-check' : 'fi-close'; ?>"></i></span>
                                        </td>
                                        <td>
                                            <span class="d-flex align-items-center text-danger"><?php echo $ticket->exception; ?></span>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>

                <div class="card-footer border-light">
                    <a href="<?php echo base_url(); ?>/manage/import" class="btn btn-secondary">
                        <i class="fi fi-arrow-left"></i>
                        <span>Voltar</span>
                    </a>
                </div>
            </div>
        </div>
    </div>
</form>
<?php $this->endsection(); ?>
<?php $this->section('scripts'); ?>
<script src="<?php echo base_url(); ?>/assets/js/vendor.datatables.js"></script>
<?php $this->endsection(); ?>