<?php $this->extend('layout/app'); ?>

<?php $this->section('header'); ?>
<title>Importar de Ticket</title>
<?php $this->endsection(); ?>
<?php $this->section('main'); ?>

<?php
$attributes = ['class' => 'form-validate', 'id' => 'form-import'];
echo  form_open_multipart('manage/importsympla', $attributes); ?>
<div class="row g-4">
    <!-- side -->
    <div class="">
        <div class="section">
            <div class="h5 card-header border-bottom-0 fw-bold">Importar</div>
            <div class="card-body">
                <div class="row g-3 mb-3">
                    <div class="col-lg-4">
                        <div class="form-floating">
                            <select class="form-select form-select-sm filters" require id="filter-event" name="id_evento">
                                <?php foreach ($events as $e) : ?>
                                    <option value="<?php echo $e->id; ?>"><?php echo $e->evento; ?></option>
                                <?php endforeach; ?>
                            </select>
                            <label for="filter-event" class="form-label">Evento</label>
                        </div>
                    </div>
                    <div class="col-lg-5">
                        <input required type="file" id="file" class="form-control  mb-1" name="file" placeholder="formFile">
                    </div>
                    <div class="col-lg-3">
                        <button type="submit" class="btn btn-primary">
                            <svg width="18px" height="18px" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <polyline points="20 6 9 17 4 12"></polyline>
                            </svg>
                            <span>Importar</span>
                        </button>
                    </div>
                </div>
            </div>
            <!-- item list -->
            <div class="table-responsive-md">

                <table class="table table-align-middle table-sm table-striped" role="grid" aria-describedby="mobile-page-info">
                    <thead>
                        <tr>
                            <th style="width:46px">
                                <div class="form-check">
                                    ID
                                </div>
                            </th>
                            <th class="small text-muted">EVENTO</th>
                            <th class="small text-muted">TICKETEIRA</th>
                            <th class="small text-muted">PROCESSADO</th>
                            <th class="small text-muted">DATA/HORA</th>
                            <th class="small text-muted">
                                <!-- options -->
                            </th>
                        </tr>
                    </thead>
                    <tbody id="checkall-list">

                        <!-- item -->
                        <?php foreach ($imports as $k => $import) : ?>
                            <tr>
                                <th>
                                    <span class="d-block text-muted small"><?php echo $import->id; ?></span>
                                </th>
                                <td>
                                    <span class="d-block text-muted small"><?php echo $import->evento_id; ?></span>
                                </td>
                                <td>
                                    <span class="d-block text-muted small"><?php echo $import->ticketeira_id; ?></span>
                                </td>
                                <td>
                                    <span class="d-block text-muted small"><?php echo $import->processado; ?></span>
                                </td>
                                <td>
                                    <span class="d-flex align-items-center">
                                        <?php echo date('d/m/Y H:i:s', strtotime($import->datahora)); ?>
                                    </span>
                                </td>

                                <td class="dropstart text-end">
                                    <a class="btn btn-sm btn-warning" href="<?php echo base_url() . '/manage/importsymplaproccess/' . $import->id; ?>">
                                        <svg class="text-muted" width="18px" height="18px" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                            <polyline points="20 6 9 17 4 12"></polyline>
                                        </svg>
                                        <span>Editar</span>
                                    </a>
                                    <a class="btn btn-sm btn-danger" href="<?php echo base_url() . '/manage/removesymplaproccess/' . $import->id; ?>">
                                        <svg class="text-muted" width="18px" height="18px" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                            <polyline points="20 6 9 17 4 12"></polyline>
                                        </svg>
                                        <span>Excluir</span>
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
            <!-- pagination, selected items -->
        </div>
    </div>
</div>
<?php echo form_close(); ?>
<?php $this->endsection(); ?>
