<?php $this->extend('layout/app'); ?>

<?php $this->section('header'); ?>
<title><?php echo $title; ?></title>
<?php $this->endsection(); ?>
<?php $this->section('main'); ?>

<!-- user list -->
<div class="section p-0">
    <div class="card-header p-4">
        <div class="row g-3">
            <!-- review filter -->
            <div class="order-2 order-md-1 col">
                <div class="w-100">
                    <h2 class="h5 mb-0"><?php echo $title; ?></h2>
                </div>
            </div>
            <div class="order-1 order-md-2 col-md-auto">
                <button type="button" id="btn-expo" class="w-100 btn btn-soft btn-sm btn-success">
                    <svg width="16px" height="16px" xmlns="http://www.w3.org/2000/svg" fill="currentColor" class="bi bi-arrow-bar-down" viewBox="0 0 16 16">
                        <path fill-rule="evenodd" d="M1 3.5a.5.5 0 0 1 .5-.5h13a.5.5 0 0 1 0 1h-13a.5.5 0 0 1-.5-.5zM8 6a.5.5 0 0 1 .5.5v5.793l2.146-2.147a.5.5 0 0 1 .708.708l-3 3a.5.5 0 0 1-.708 0l-3-3a.5.5 0 0 1 .708-.708L7.5 12.293V6.5A.5.5 0 0 1 8 6z"></path>
                    </svg>
                    <span> Exportar</span>
                </button>
            </div>
        </div>
    </div>

    <div class="card-body pt-1">

        <!-- item list -->
        <div class="table-responsive-md">
            <div class="row align-items-start my-4">
                <div class="order-1 col-xl-3 col-md-auto">
                    <label for="filter-event" class="form-label">Evento</label>
                    <select class="form-select form-select-sm filters" id="filter-event" name="event">
                        <option value="" selected>Todos</option>
                        <?php foreach ($events as $e) : ?>
                            <option value="<?php echo $e->id; ?>"><?php echo $e->evento; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="order-1 col-xl-3 col-md-auto">
                    <label for="filter-tipo" class="form-label">Tipo</label>
                    <select class="form-select form-select-sm filters" id="filter-tipo" name="tipo">
                        <option value="" selected>Todos</option>
                        <?php foreach ($types as $tipo) : ?>
                            <option value="<?php echo $tipo; ?>"><?php echo $tipo; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="order-1 col-xl-3 col-md-auto">
                    <label for="filter-category" class="form-label">Categoria</label>
                    <select class="form-select form-select-sm filters" id="filter-category" name="category">
                        <option value="" data-tipo="" selected>Todos</option>
                        <?php foreach ($categories as $ca) : ?>
                            <option value="<?php echo $ca->id; ?>" data-tipo="<?php echo $ca->tipo; ?>"><?php echo $ca->categoria; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="order-1 col-xl-3 col-md-auto">
                    <label for="filter-mestre" class="form-label">Mestre</label>
                    <select class="form-select form-select-sm filters" id="filter-mestre" name="mestre">
                        <option value="" selected>Todos</option>
                        <option value="1" selected>Sim</option>
                        <option value="0" selected>Não</option>
                    </select>
                </div>
                <!-- <div class="order-1 col-xl-2 col-md-auto">
                    <label for="filter-status" class="form-label">Status</label>
                    <select class="form-select form-select-sm filters" id="filter-status" name="status">
                        <option value="" selected>Todos</option>
                        <option value="1">Ativo</option>
                        <option value="0">Bloqueado</option>
                    </select>
                </div> -->
            </div>

            <table class="table datatable table-bordered table-hover table-striped" id="datatable" role="grid" aria-describedby="mobile-page-info">
                <thead>
                    <tr>
                        <th class="small text-muted">EVENTO</th>
                        <th class="small text-muted">TIPO</th>
                        <th class="small text-muted">CATEGORIA</th>
                        <th class="small text-muted">#TICKET CODE</th>
                        <th class="small text-muted">NOME</th>
                        <th class="small text-muted">STATUS</th>
                        <th class="small text-muted">MESTRE</th>
                        <th class="small text-muted">TERMINAL</th>
                        <th class="small text-muted">LEITURA</th>
                        <th class="small text-muted">#</th>
                    </tr>
                </thead>
                <tbody>
                </tbody>
            </table>
        </div>
    </div>
</div>
<!-- /widgets -->
<?php $this->endsection(); ?>
<?php $this->section('scripts'); ?>
<script src="<?php echo base_url(); ?>/assets/js/vendor.datatables.js"></script>
<script>
    $(document).ready(function() {
        $('.filters').change(function() {
            $('#datatable').DataTable().ajax.reload();
        });

        $('#filter-tipo').change(() => {
            $("#filter-category").find('option').each((iex, el) => {
                if ($('#filter-tipo').val() == $(el).data('tipo') ||
                    $('#filter-tipo').val() == '' ||
                    $(el).data('tipo') == '') {
                    $(el).show()
                } else {
                    $(el).hide()
                }
            })
        })

        $('#btn-expo').click(function() {
            const data = {
                event: $('#filter-event').val(),
                type: $('#filter-tipo').val(),
                master: $('#filter-mestre').val(),
                category: $('#filter-category').val(),
            }

            $.post("<?php echo base_url(); ?>/report/<?php echo $sub; ?>/expo", data, ((resp) => {
                console.log(resp)
                var csv = resp.map(function(d) {
                        return JSON.stringify(Object.values(d));
                    })
                    .join('\n')
                    .replace(/(^\[)|(\]$)/mg, '');
                console.log(csv)

                var a = window.document.createElement('a');

                a.href = window.URL.createObjectURL(new Blob([csv], {
                    type: 'application/octet-stream'
                }));
                a.download = 'download.csv';

                // Append anchor to body.
                document.body.appendChild(a)
                a.click();


                // Remove anchor from body
                document.body.removeChild(a)
            }))
        })


        var table = $('#datatable').dataTable({
            processing: true,
            serverSide: true,
            pageLength: 10,
            searchDelay: 600,
            order: [
                [0, "desc"],
                [1, "asc"]
            ],
            ajax: {
                "url": "<?php echo base_url(); ?>/report/<?php echo $sub; ?>/data",
                "data": function(d) {
                    var event = $('#filter-event').val();
                    var type = $('#filter-tipo').val();
                    var master = $('#filter-mestre').val();
                    var category = $('#filter-category').val();
                    //var situacao = $('#filter-status').val();
                    return $.extend({}, d, {

                        master,
                        type,
                        category,
                        event
                    });
                }
            },
            loadingMessage: 'Carregando...',
            dom: '<"toolbar">frtip',
            class: 'pagination',
            columnDefs: [{
                responsivePriority: 1,
                targets: 0
            }],
            language: {
                emptyTable: "Nenhum registro destaqueizado.",
                info: "Exibindo _START_ até _END_ de _TOTAL_ registros",
                infoEmpty: "Exibindo 0 até 0 de 0 registros",
                infoFiltered: "(filtrados de _MAX_ no total)",
                infoPostFix: "",
                thousands: ",",
                lengthMenu: "Exibindo _MENU_ registros",
                loadingRecords: "Carregando...",
                processing: "Processando...",
                search: "Busca:",
                zeroRecords: "Nenhum registro destaqueizado.",
                paginate: {
                    first: "Primeiro",
                    last: "Ultimo",
                    next: "Prox.",
                    previous: "Ant."
                },
                aria: {
                    sortAscending: ": activate to sort column ascending",
                    sortDescending: ": activate to sort column descending"
                }
            }
        });
    });
</script>

<?php $this->endsection(); ?>