<?php $this->extend('layout/monitor'); ?>

<?php $this->section('header'); ?>
<title>Monitor de Catraca</title>
<?php $this->endsection(); ?>
<?php $this->section('main'); ?>

<div class="container bg-gray-500 shadow-sm">

    <div class="py-2 px-3 mb-3 mt-1">
        <div class="row g-3">

            <!-- review filter -->
            <div class="order-2 order-md-1 col">
                <div class="w-100">
                    <a href="<?php echo base_url(); ?>">
                        <img src="<?php echo base_url(); ?>/assets/images/logo/logo-one.svg" width="150" />
                    </a>
                </div>
            </div>

            <!-- options -->
            <div class="order-1 order-md-2 col-md-auto">
                <select class="form-control form-select" id="evento">
                    <?php foreach($eventos as $e): ?>
                        <option value="<?php echo $e->id; ?>"><?php echo $e->evento; ?></option>
                    <?php endforeach; ?>
                </select>
            </div>

        </div>

    </div>
    <div class="row g-0 min-vh-100">
        <div class="col-md-12 mx-auto py-6 text-center">
            <h1 class="display-5 fw-bold text-primary">Review</h1>
            <p class="lead"></p>

            <div class="col-12 col-xl-12">
                <div class="portlet">
                    <div class="portlet-header">
                        <span class="d-block text-muted text-truncate fw-medium">
                            Tickets & Acessos
                        </span>
                    </div>
                    <div id="tabUserListContent" class="portlet-body tab-content">
                        <div class="h-100 tab-pane show active table-responsive-md" id="usertab_1">
                            <table class="table datatable table-bordered table-hover table-striped">
                                <thead>
                                    <tr>
                                        <th>TIPO</th>
                                        <th scope="col">CATEGORIA</th>
                                        <th scope="col">REGISTROS</th>
                                        <th scope="col">ATIVOS</th>
                                        <th scope="col">INATIVOS</th>
                                        <th scope="col">LEITURAS</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($dataSynth as $ds) : ?>
                                        <tr>
                                            <td class="text-start"><?php echo $ds->tipo; ?></td>
                                            <td class="text-start"><?php echo $ds->categoria; ?></td>
                                            <td><span id='tickets_<?php echo $ds->id; ?>'></span></td>
                                            <td><span id='tickets_ativos_<?php echo $ds->id; ?>'></span></td>
                                            <td><span id='tickets_bloqueados_<?php echo $ds->id; ?>'></span></td>
                                            <td><span id='tickets_lido_<?php echo $ds->id; ?>'></span></td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <div class="d-flex align-items-center justify-content-between border-bottom pb-2 pt-4 my-2">
                <div class="w-100">
                    <h6 class="h5 mb-0">Entradas</h6>
                    <div id="chart-tickets">
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $this->endsection(); ?>
<?php $this->section('scripts'); ?>
<script src="<?php echo base_url(); ?>/assets/js/apexcharts.js"></script>
<script>
    $(document).ready(function() {

        const options = {
            chart: {
                type: 'bar'
            },
            series: []
        }
        const chartTicket = new ApexCharts(document.querySelector("#chart-tickets"), options);
        chartTicket.render();

        setInterval(() => {
            getResume()
        }, 2000)

        setInterval(() => {
            getDataChart()
        }, 3000)

        const getResume = () => {
            let evento = $("#evento").val();
            $.get('<?php echo base_url(); ?>/review/data/'+evento, (response) => {

                if (response) {
                    //console.log(response)
                    response.forEach(el => {
                        if ($('#tickets_' + el.id).length) {
                            $('#tickets_' + el.id).html(el.tickets)
                            $('#tickets_ativos_' + el.id).html(el.tickets_ativos)
                            $('#tickets_bloqueados_' + el.id).html(el.tickets_bloqueados)
                            $('#tickets_lido_' + el.id).html(el.tickets_lido_unico)
                        }
                    })
                }
            }).done(() => {
                //
            })
        }

        const getDataChart = () => {
            let evento = $("#evento").val();
            $.get('<?php echo base_url(); ?>/review/graphic/'+evento, (response) => {

                if (response != null) {
                    chartTicket.updateSeries([{
                        data: response.ticket
                    }])
                }
            }).done(() => {
                //
            })
        }
    })
</script>
<?php $this->endsection(); ?>