<?php $this->extend('layout/monitor'); ?>

<?php $this->section('header'); ?>
<title>Monitor de Catraca</title>
<?php $this->endsection(); ?>
<?php $this->section('main'); ?>
<style>
    html,
    body {
        height: 100%;
    }

    .container,
    .row.justify-content-center.align-items-center {
        height: 100%;
        min-height: 100%;
    }
</style>
<div class="border d-flex align-items-center justify-content-center" style="height: 100%;">
    <div class="container d-flex align-items-center justify-content-center h-100  w-100">
        <div class="d-flex flex-column  w-100">
            <h1 class="align-self-start">PUBLICO TOTAL

            </h1>
            <div id="publico-total" class="text-center border border-light alert alert-dark" style="width: 100%; font-size: 10rem;">
                ----
            </div>
            <div class="align-self-center w-100">
                <div class="row ">
                    <div class="col">
                        <span id="icon-reload">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="green" class="bi bi-circle-fill" viewBox="0 0 16 16">
                                <circle cx="8" cy="8" r="8" />
                            </svg>
                        </span>
                        <span id="icon-stop">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="red" class="bi bi-circle-fill" viewBox="0 0 16 16">
                                <circle cx="8" cy="8" r="8" />
                            </svg>
                        </span>
                    </div>
                    <div class="col">
                        <span id="last-date">----</span>
                    </div>
                    <div class="col">

                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="position-absolute top-0 end-0 m-4">
        <button class="navbar-toggler collapsed" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasRight" aria-controls="offcanvasRight" aria-expanded="false" aria-label="Toggle navigation">
            <svg xmlns="http://www.w3.org/2000/svg" width="64" height="64" fill="gray" class="bi bi-list" viewBox="0 0 16 16">
                <path fill-rule="evenodd" d="M2.5 12a.5.5 0 0 1 .5-.5h10a.5.5 0 0 1 0 1H3a.5.5 0 0 1-.5-.5zm0-4a.5.5 0 0 1 .5-.5h10a.5.5 0 0 1 0 1H3a.5.5 0 0 1-.5-.5zm0-4a.5.5 0 0 1 .5-.5h10a.5.5 0 0 1 0 1H3a.5.5 0 0 1-.5-.5z" />
            </svg>
        </button>
    </div>

    <div class="offcanvas offcanvas-end" tabindex="-1" id="offcanvasRight" aria-labelledby="offcanvasRightLabel">
        <div class="offcanvas-header">
            <h5 id="offcanvasRightLabel">Offcanvas right</h5>
            <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas" aria-label="Close"></button>
        </div>
        <div class="offcanvas-body">
            <div class="form-control">
                <h2>Configurações</h2>
                <div class="row g-3">
                    <div class="col-lg-12">
                        <label for="startDate">Início</label>
                        <input required type="datetime-local" class="form-control" id="startDate" name="startDate" placeholder="Data de início" value="">
                    </div>
                    <div class="col-lg-12">
                        <label for="endDate">Fim</label>
                        <input required type="datetime-local" class="form-control" id="endDate" name="endDate" placeholder="Data de encerramento" value="">
                    </div>
                    <div class="col-12">
                        <button class="w-100 btn btn-primary btn-lg" type="button" id="btn-save">Salvar</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
</div>
<?php $this->endsection(); ?>
<?php $this->section('scripts'); ?>
<script>

    const storage = {
            load: (name) => {
                const rawValue = localStorage.getItem(name)

                if (storage.isJson(rawValue)) {
                    return JSON.parse(rawValue)
                } else {
                    return {
                        rawValue
                    }
                }
            },
            save: (name, obj) => {
                localStorage.setItem(name, JSON.stringify(obj))
            },
            delete: (name) => {
                localStorage.removeItem(name)
            },
            isJson: function(str) {
                try {
                    JSON.parse(str)
                } catch (e) {
                    return false
                }
                return true
            }
        }

    $(document).ready(function() {
        const params = {
            startDate: null,
            endDate: null
        }
        $("#btn-save").click(function() {
            params.startDate = $("#startDate").val()
            params.endDate = $("#endDate").val()
            storage.save('publico', params)
        })

        let lo = storage.load('publico')

        if(lo !== null) {
            if(lo.hasOwnProperty('startDate')) {
                params.startDate = lo.startDate
                $("#startDate").val(params.startDate)
            }

            if(lo.hasOwnProperty('endDate')) {
                params.endDate = lo.endDate
                $("#endDate").val(params.endDate)
            }
        }

        setInterval(() => {
            publico()
        }, 400);

        const publico = () => {
            let uri = '<?php echo base_url(); ?>'
            const data = new URLSearchParams(params);
            $("#icon-reload").show();
            $("#icon-stop").hide();
            $.get(uri + '/publico/state?max=250&' + data.toString(), (response) => {
                if (response.status) {
                    $("#icon-reload").hide();
                    $("#icon-stop").show();
                    $("#publico-total").html(response.total)
                    $("#last-date").html(response.lastDate)
                } else {
                    $("#publico-total").html('----')
                    $("#last-date").html('----')
                }
            })
        }

        
    })
</script>
<?php $this->endsection(); ?>