<?php $this->extend('layout/monitor'); ?>

<?php $this->section('header'); ?>
<title>Monitor de Catraca</title>
<?php $this->endsection(); ?>
<?php $this->section('main'); ?>
<header>
    <div class="navbar navbar-dark bg-dark shadow-sm">
        <div class="container">
            <a href="#" class="navbar-brand d-flex align-items-center">
                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" aria-hidden="true" class="me-2" viewBox="0 0 24 24">
                    <path d="M23 19a2 2 0 0 1-2 2H3a2 2 0 0 1-2-2V8a2 2 0 0 1 2-2h4l2-3h6l2 3h4a2 2 0 0 1 2 2z" />
                    <circle cx="12" cy="13" r="4" />
                </svg>
                <strong>One</strong>
            </a>
        </div>
    </div>
</header>


<div id="main">
    <div class="row">
        <div class="col-md-6">
            <div class="p-4 text-secondary bg-dark">
                <input type="text" class="form-control form-control-lg btn-success" id="card" />
            </div>
            <div class="form-control form-control-sm text-center text-white" id="data_1">nome</div>
            <div class="form-control form-control-sm text-center" id="data_2">****</div>
            <div class="form-control form-control-sm text-center" id="data_3">****</div>
        </div>
        <div class="col-md-6">
            <div class="p-2">
                <img class="img img-responsive" style="width: 100%" id="foto" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAAHElEQVQI12P4//8/w38GIAXDIBKE0DHxgljNBAAO9TXL0Y4OHwAAAABJRU5ErkJggg==" alt="" />
            </div>
        </div>
    </div>
</div>
<footer id="footer" class=" fixed-bottom text-white-50 bg-danger">
    <div class="text-center" id="connect-status"></div>
</footer>

<?php $this->endsection(); ?>
<?php $this->section('scripts'); ?>
<script>
    $(document).ready(function() {
        var lastAccessId = null
        var readyStatus = false
        var acao = [
            { key: 'PS', value: 'PASSAGEM LIBERADA' },
            { key: 'CI', value: 'TICKET INVÁLIDO' },
            { key: 'CB', value: 'TICKET BLOQUEADO' },
            { key: 'CR', value: 'TICKET REGISTRADO' },
            { key: 'CE', value: 'EVENTO EXPIRADO' },
            { key: 'CN', value: '..FALHA CONEXÃO..' },
            { key: 'CS', value: '..FALHA SOCKET..' },
            { key: 'EG', value: 'AGUARDANDO GIRO' },
            { key: 'EX', value: 'AGUARDANDO GIRO' }
        ]
        var uri = '<?php echo base_url(); ?>'
        setInterval(() => {
            if (!readyStatus) {
                getRegister()
            } else {
                console.log('aguarde...')
            }
        }, 500)

        function getRegister() {
            readyStatus = true
            $.get(uri + '/monitor/acesso?id=<?php echo $device->id; ?>', (response) => {

                if (response != null) {
                    response.forEach((el, idx) => {
                        let cid = el.cid +"";
                        let image = uri + `/monitor/photo/${cid}`;
                        // console.log('image',image )
                        // let dimage = `image-${idx}`
                        $('#foto').attr('src', image)
                        // $('#data_1').html(el.nome_pessoa)
                        // $('#data_2').html(el.categoria)
                        // $('#data_3').html(el.acao)


                        const index = acao.findIndex(aa => aa.key === el.acao)
                        $('#data_1').html(el.nome_pessoa)
                        if (index !== -1) {
                            $('#data_2').html(acao[index].value)
                        }
                        if (el.acao == 'PS') {
                            $('#data_1').removeClass('bg-warning');
                            $('#data_1').removeClass('bg-danger');
                            $('#data_1').addClass('bg-success');
                        } else if (el.acao == 'CR') {
                            $('#data_1').removeClass('bg-warning');
                            $('#data_1').removeClass('bg-success');
                            $('#data_1').addClass('bg-danger');
                            const date = el.data_acesso
                            const readable_date = new Date(date).toLocaleString("pt-BR", {timeZone: 'America/Sao_Paulo'});   
                            console.log(readable_date);
                            $('#data_2').html("Registro em " + readable_date);
                        } else {
                            $('#data_1').removeClass('bg-warning');
                            $('#data_1').removeClass('bg-success');
                            $('#data_1').addClass('bg-danger');
                        }
                        
                        $('#data_3').html(el.categoria)

                    })
                }
            }).done(() => {
                readyStatus = false
            })
        }

    })
</script>
<?php $this->endsection(); ?>