<?php $this->extend('layout/monitor'); ?>

<?php $this->section('header'); ?>
<title>Eventos</title>
<?php $this->endsection(); ?>
<?php $this->section('main'); ?>

<div class="cover-container d-flex w-100 h-100 p-3 mx-auto flex-column">
    <header class="mb-auto">
        <div>
            <h3 class="float-md-start mb-0">Monitor</h3>
            <nav class="nav nav-masthead justify-content-center float-md-end">
                <button class="btn btn-sm btn-secondary dropdown-toggle" type="button" id="dropdownMenuButton1" data-bs-toggle="dropdown" aria-expanded="false">
                    Devices <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-list" viewBox="0 0 16 16">
                        <path fill-rule="evenodd" d="M2.5 12a.5.5 0 0 1 .5-.5h10a.5.5 0 0 1 0 1H3a.5.5 0 0 1-.5-.5zm0-4a.5.5 0 0 1 .5-.5h10a.5.5 0 0 1 0 1H3a.5.5 0 0 1-.5-.5zm0-4a.5.5 0 0 1 .5-.5h10a.5.5 0 0 1 0 1H3a.5.5 0 0 1-.5-.5z" />
                    </svg>
                </button>
                <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
                    <?php foreach($devices as $k => $device): ?>
                        <li>
                            <a class="dropdown-item" href="<?php echo base_url(); ?>/monitor/device/<?php echo $device->id; ?>"><?php echo $device->terminal_nome; ?></a>
                        </li>
                    <?php endforeach; ?>
                </ul>
            </nav>
        </div>
    </header>

    <main class="px-1">
        <div class="container">
        </div>
    </main>

    <footer class="mt-auto text-white-50 fixed-bottom">
        <p>aaa.</p>
    </footer>
</div>

<!-- /widgets -->
<?php $this->endsection(); ?>
<?php $this->section('scripts'); ?>
<script>
    $(document).ready(function() {
        var readyStatus = false
        var uri = '<?php echo base_url(); ?>'
        setInterval(() => {
            if (!readyStatus) {
                // getRegister()
            } else {
                // console.log('aguarde...')
            }
        }, 200)

        function getRegister()
        {
            readyStatus = true
            $.get(uri+'/monitor/acesso', (response) => {
                
                if(response != null) {
                    response.forEach((el,idx)=> {
                        let image = `${uri}/monitor/photo/${el.cid}`;
                        let dimage = `image-${idx}`
                        $(`#${dimage}`).attr('src', image)
                    })
                }
            }).done(() => {
                readyStatus = false
            })
        }

        function getData()
        {
            let data = sessionStorage.getItem("ids");
            if(data === null) {
                data = []
                sessionStorage.setItem("ids", JSON.stringify(data));
            }
            return data
        }

        function addData(id)
        {
            let data = JSON.parse(getData())
            data.push(id)
            sessionStorage.setItem("ids", JSON.stringify(data));
        }

        function clearData()
        {
            sessionStorage.removeItem("ids");
            let data = [];
            sessionStorage.setItem("ids", JSON.stringify(data));
            return data
        }
    })
</script>
<?php $this->endsection(); ?>