<?php $this->extend('layout/monitor'); ?>

<?php $this->section('header'); ?>
<title>Monitor de Catraca</title>
<?php $this->endsection(); ?>
<?php $this->section('main'); ?>

<header>
    <div class="offcanvas offcanvas-end" tabindex="-1" id="offcanvasRight" aria-labelledby="offcanvasRightLabel">
        <div class="offcanvas-header">
            <h5 id="offcanvasRightLabel">Configurações</h5>
            <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas" aria-label="Close"></button>
        </div>
        <div class="offcanvas-body">
            <div class="row g-3">
                <div class="col-12">
                    <label for="host" class="form-label">HOST</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text"><i class="bi bi-server"></i></span>
                        <input type="text" class="form-control" id="host" placeholder="Endereço do servidor" required="">
                    </div>
                </div>
                <div class="col-12">
                    <label for="email" class="form-label">Porta (9002)</label>
                    <input type="email" class="form-control" id="port" placeholder="Porta do socket(servidor)">
                </div>
                <div class="col-12">
                    <label for="email" class="form-label">PIN</label>
                    <input type="email" class="form-control" id="pin" placeholder="Identificação do leitor">
                </div>
                <div class="col-12">
                    <button class="w-100 btn btn-primary btn-lg" type="button" id="btn-save">Salvar</button>
                </div>
            </div>
        </div>
    </div>
    <div class="navbar navbar-dark bg-dark shadow-sm">
        <div class="container">
            <a href="#" class="navbar-brand d-flex align-items-center">
                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" aria-hidden="true" class="me-2" viewBox="0 0 24 24">
                    <path d="M23 19a2 2 0 0 1-2 2H3a2 2 0 0 1-2-2V8a2 2 0 0 1 2-2h4l2-3h6l2 3h4a2 2 0 0 1 2 2z" />
                    <circle cx="12" cy="13" r="4" />
                </svg>
                <strong>One</strong>
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasRight" aria-controls="offcanvasRight">
                <span class="navbar-toggler-icon"></span>
            </button>
        </div>
    </div>
</header>


<div id="main">
    <div class="row">
        <div class="col-md-6">
            <div class="p-4 text-secondary bg-dark">
                <input type="text" class="form-control form-control-lg btn-success" id="card" />
            </div>
            <div class="form-control form-control-sm text-center text-white" id="data_1">****</div>
            <div class="form-control form-control-sm text-center" id="data_2">****</div>
            <div class="form-control form-control-sm text-center" id="data_3">****</div>
        </div>
        <div class="col-md-6">
            <div class="p-2">
                <img class="img img-responsive" style="width: 100%" id="foto" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAAHElEQVQI12P4//8/w38GIAXDIBKE0DHxgljNBAAO9TXL0Y4OHwAAAABJRU5ErkJggg==" alt="" />
            </div>
        </div>
    </div>
</div>
<footer id="footer" class=" fixed-bottom text-white-50 bg-danger">
    <div class="text-center" id="connect-status"></div>
</footer>
</div>

<!-- /widgets -->
<?php $this->endsection(); ?>
<?php $this->section('scripts'); ?>
<script>
    $(document).ready(function() {
        var readyStatus = false
        var uri = '<?php echo base_url(); ?>'
        setInterval(() => {
            if (!readyStatus) {
                // getRegister()
            } else {
                // console.log('aguarde...')
            }
        }, 200)

        function getRegister() {
            readyStatus = true
            $.get(uri + '/monitor/acesso', (response) => {

                if (response != null) {
                    response.forEach((el, idx) => {
                        let image = `${uri}/monitor/photo/${el.cid}`;
                        let dimage = `image-${idx}`
                        $(`#${dimage}`).attr('src', image)
                    })
                }
            }).done(() => {
                readyStatus = false
            })
        }

        function getData() {
            let data = sessionStorage.getItem("ids");
            if (data === null) {
                data = []
                sessionStorage.setItem("ids", JSON.stringify(data));
            }
            return data
        }

        function addData(id) {
            let data = JSON.parse(getData())
            data.push(id)
            sessionStorage.setItem("ids", JSON.stringify(data));
        }

        function clearData() {
            sessionStorage.removeItem("ids");
            let data = [];
            sessionStorage.setItem("ids", JSON.stringify(data));
            return data
        }
    })
</script>
<?php $this->endsection(); ?>