<?php $this->extend('layout/app'); ?>

<?php $this->section('header'); ?>
<title>Importar de Ticket</title>
<?php $this->endsection(); ?>
<?php $this->section('main'); ?>

<?php
    $attributes = ['class' => 'form-validate', 'id' => 'form-import'];
    echo  form_open_multipart('manage/import', $attributes) ;?>
    <div class="row g-4">
        <!-- side -->
        <div class="">
            <div class="section">
                <div class="h5 card-header border-bottom-0 fw-bold">Importar</div>
                <div class="card-body">
                    <div class="row g-3 mb-3">
                        <div class="col-lg-6">
                            <div class="form-floating">
                                <select class="form-select form-select-sm filters" require id="filter-event" name="id_evento">
                                    <?php foreach ($events as $e) : ?>
                                        <option value="<?php echo $e->id; ?>"><?php echo $e->evento; ?></option>
                                    <?php endforeach; ?>
                                </select>
                                <label for="filter-event" class="form-label">Evento</label>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="form-floating">
                                <select class="form-select form-select-sm filters" require id="filter-category" name="id_categoria">
                                    <?php foreach ($categories as $ca) : ?>
                                        <option value="<?php echo $ca->id; ?>"><?php echo $ca->categoria; ?></option>
                                    <?php endforeach; ?>
                                </select>
                                <label for="filter-category" class="form-label">Categoria</label>
                            </div>
                        </div>
                    </div>
                    <div class="row g-3 mb-3">
                        <div class="col-lg-3">
                            <div class="form-control">
                                <label class="d-flex align-items-center mb-1">
                                    <input class="d-none-cloaked" type="checkbox" name="situacao" id="situacao" checked value="1">
                                    <i class="switch-icon switch-icon-primary switch-icon-xs"></i>
                                    <span class="px-3 user-select-none">Ticket Ativo</span>
                                </label>
                            </div>
                        </div>
                        <div class="col-lg-3">
                            <div class="form-control">
                                <label class="d-flex align-items-center mb-1">
                                    <input class="d-none-cloaked" type="checkbox" name="mestre" id="mestre" value="1">
                                    <i class="switch-icon switch-icon-primary switch-icon-xs"></i>
                                    <span class="px-3 user-select-none">Cartão Mestre</span>
                                </label>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <input required type="file" id="file" class="form-control  mb-1" name="file" placeholder="formFile" title="Tamanho do código (digitos), de 4 à 32">
                            <span class="text-danger">Formato CSV separado por ponto-virgula e sem cabeçalho<br/>
                            <small>Ticket, Nome, Email, RG, CPF, CE1, CE2, Status, Mestre</small></br/>
                            <b>Exemplo: </b>"03254521";"Fulano","","","campo1","campo2","1","0"
                            </span>
                        </span>
                        </div>
                        
                    </div>
                </div>
                <div class="card-footer border-light">
                    <button type="submit" class="btn btn-primary">
                        <svg width="18px" height="18px" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <polyline points="20 6 9 17 4 12"></polyline>
                        </svg>
                        <span>Importar</span>
                    </button>
                    
                </div>
            </div>
        </div>
    </div>
</form>
<?php $this->endsection(); ?>