<?php $this->extend('layout/app'); ?>

<?php $this->section('header'); ?>
<title>Gerador de Ticket</title>
<?php $this->endsection(); ?>
<?php $this->section('main'); ?>

<form class="form-validate" method="post" action="<?php echo base_url() . '/manage/generate'; ?>" id="form-generate">
    <div class="row g-4">
        <!-- side -->
        <div class="">
            <div class="section">
                <div class="h5 card-header border-bottom-0 fw-bold">Gerar Tickets</div>
                <div class="card-body">
                    <div class="row g-3 mb-3">
                        <div class="col-lg-4">
                            <div class="form-floating">
                                <select class="form-select form-select-sm filters" require id="filter-event" name="id_evento">
                                    <?php foreach ($events as $e) : ?>
                                        <option value="<?php echo $e->id; ?>"><?php echo $e->evento; ?></option>
                                    <?php endforeach; ?>
                                </select>
                                <label for="filter-event" class="form-label">Evento</label>
                            </div>
                        </div>
                        <div class="col-lg-4">
                            <div class="form-floating">
                                <select class="form-select form-select-sm filters" require id="filter-category" name="id_categoria">
                                    <?php foreach ($categories as $ca) : ?>
                                        <option value="<?php echo $ca->id; ?>"><?php echo $ca->categoria; ?></option>
                                    <?php endforeach; ?>
                                </select>
                                <label for="filter-category" class="form-label">Categoria</label>
                            </div>
                        </div>
                        <div class="col-lg-2">
                            <div class="form-floating">
                                <input required type="number" min="0" max="5000" step="1"  class="form-control" id="qtd_ticket" name="qtd_ticket" placeholder="Quantidade" value="0" title="Quantidade de tickets, de 1 até 5000">
                                <label for="qtd_ticket">Quantidade</label>
                            </div>
                        </div>
                        <div class="col-lg-2">
                            <div class="form-floating">
                                <input required type="number" min="4" max="64" step="1" class="form-control" id="size" name="size" placeholder="size" value="8" title="Tamanho do código (digitos), de 4 à 32">
                                <label for="size">Tamanho <i class="fi fi-round-question-full"></i></label>
                            </div>
                        </div>
                    </div>
                    <div class="row g-3 mb-3">
                        <div class="col-lg-3">
                            <div class="form-control">
                                <label class="d-flex align-items-center mb-1">
                                    <input class="d-none-cloaked" type="checkbox" name="situacao" id="situacao" checked value="1">
                                    <i class="switch-icon switch-icon-primary switch-icon-xs"></i>
                                    <span class="px-3 user-select-none">Ticket Ativo</span>
                                </label>
                            </div>
                        </div>
                        <div class="col-lg-3">
                            <div class="form-control">
                                <label class="d-flex align-items-center mb-1">
                                    <input class="d-none-cloaked" type="checkbox" name="mestre" id="mestre" value="1">
                                    <i class="switch-icon switch-icon-primary switch-icon-xs"></i>
                                    <span class="px-3 user-select-none">Cartão Mestre</span>
                                </label>
                            </div>
                        </div>
                        <div class="col-lg-3">
                            <div class="form-floating">
                                <input type="text" class="form-control" id="campoextra1" name="campoextra1" placeholder="Campo Extra 1" value="">
                                <label for="local">Campo Extra 1</label>
                            </div>
                        </div>
                        <div class="col-lg-3">
                            <div class="form-floating">
                                <input type="text" class="form-control" id="campoextra2" name="campoextra2" placeholder="Campo Extra 2" value="">
                                <label for="local">Campo Extra 2</label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-footer border-light">
                    <button type="submit" class="btn btn-primary">
                        <svg width="18px" height="18px" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <polyline points="20 6 9 17 4 12"></polyline>
                        </svg>
                        <span>Criar</span>
                    </button>
                </div>
            </div>
        </div>
    </div>
</form>
<?php $this->endsection(); ?>