<?php $this->extend('layout/app'); ?>

<?php $this->section('header'); ?>
<title>Exportar Ticket</title>
<?php $this->endsection(); ?>
<?php $this->section('main'); ?>

<form class="form-validate" method="post" action="<?php echo base_url() . '/manage/export'; ?>" id="form-generate">
    <div class="row g-4">
        <!-- side -->
        <div class="">
            <div class="section">
                <div class="h5 card-header border-bottom-0 fw-bold">Exportar Tickets</div>
                <div class="card-body">
                    <div class="row g-3 mb-3">
                        <div class="col-lg-4">
                            <div class="form-floating">
                                <select class="form-select form-select-sm filters" require id="filter-event" name="id_evento">
                                    <?php foreach ($events as $e) : ?>
                                        <option value="<?php echo $e->id; ?>"><?php echo $e->evento; ?></option>
                                    <?php endforeach; ?>
                                </select>
                                <label for="filter-event" class="form-label">Evento</label>
                            </div>
                        </div>
                        <div class="col-lg-4">
                            <div class="form-floating">
                                <select class="form-select form-select-sm filters" require id="filter-category" name="id_categoria">
                                    <option value="">Todos</option>
                                    <?php foreach ($categories as $ca) : ?>
                                        <option value="<?php echo $ca->id; ?>"><?php echo $ca->categoria; ?></option>
                                    <?php endforeach; ?>
                                </select>
                                <label for="filter-category" class="form-label">Categoria</label>
                            </div>
                        </div>
                        <div class="col-lg-2">
                            <div class="form-floating">
                                <select class="form-select form-select-sm filters" require id="filter-category" name="status">
                                    <option value="">Todos</option>
                                    <option value="2">Inativos</option>
                                    <option value="1">Ativos</option>
                                </select>
                                <label for="filter-category" class="form-label">Status</label>
                            </div>
                        </div>
                        <div class="col-lg-2">
                            <div class="form-floating">
                                <select class="form-select form-select-sm filters" require id="filter-category" name="mestre">
                                    <option value="">Todos</option>
                                    <option value="1">Somente mestre</option>
                                    <option value="2">não mestre</option>
                                </select>
                                <label for="filter-category" class="form-label">Cartão mestre</label>
                            </div>
                        </div>
                    </div>
                    <div class="row g-3 mb-3">
                        <div class="col-lg-3">
                            <div class="form-floating">
                                <select class="form-select form-select-sm filters" require id="filter-category" name="leitura">
                                    <option value="">Todos</option>
                                    <option value="1">Somente com leitura</option>
                                    <option value="2">Somente sem leitura</option>
                                </select>
                                <label for="filter-category" class="form-label">Leitura</label>
                            </div>
                        </div>
                        <div class="col-lg-3">
                            <div class="form-floating">
                                <select class="form-select form-select-sm filters" require id="filter-filetype" name="filetype">
                                    <option value="csv">Arquivo CSV</option>
                                    <option value="json">Arquivo JSON</option>
                                    <option value="xml">Arquivo XML</option>
                                </select>
                                <label for="filter-category" class="form-label">Tipo de arquivo</label>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="form-control p-2">
                                <div class="h6">Campos</div>
                                <div class="list-group sortable">
                                    <div class="list-group-item py-0">
                                        <label class="d-flex align-items-center">
                                            <svg width="16px" height="16px" xmlns="http://www.w3.org/2000/svg" fill="currentColor" class="bi bi-arrow-down-up me-1" viewBox="0 0 16 16">
                                                <path fill-rule="evenodd" d="M11.5 15a.5.5 0 0 0 .5-.5V2.707l3.146 3.147a.5.5 0 0 0 .708-.708l-4-4a.5.5 0 0 0-.708 0l-4 4a.5.5 0 1 0 .708.708L11 2.707V14.5a.5.5 0 0 0 .5.5zm-7-14a.5.5 0 0 1 .5.5v11.793l3.146-3.147a.5.5 0 0 1 .708.708l-4 4a.5.5 0 0 1-.708 0l-4-4a.5.5 0 0 1 .708-.708L4 13.293V1.5a.5.5 0 0 1 .5-.5z"></path>
                                            </svg>
                                            <input class="d-none-cloaked" checked type="checkbox" name="order[]" id="cod" value="cod">
                                            <i class="switch-icon switch-icon-primary switch-icon-xs"></i>
                                            <span class="px-3 user-select-none">Código</span>
                                        </label>
                                    </div>
                                    <div class="list-group-item py-0">
                                        <label class="d-flex align-items-center">
                                            <svg width="16px" height="16px" xmlns="http://www.w3.org/2000/svg" fill="currentColor" class="bi bi-arrow-down-up me-1" viewBox="0 0 16 16">
                                                <path fill-rule="evenodd" d="M11.5 15a.5.5 0 0 0 .5-.5V2.707l3.146 3.147a.5.5 0 0 0 .708-.708l-4-4a.5.5 0 0 0-.708 0l-4 4a.5.5 0 1 0 .708.708L11 2.707V14.5a.5.5 0 0 0 .5.5zm-7-14a.5.5 0 0 1 .5.5v11.793l3.146-3.147a.5.5 0 0 1 .708.708l-4 4a.5.5 0 0 1-.708 0l-4-4a.5.5 0 0 1 .708-.708L4 13.293V1.5a.5.5 0 0 1 .5-.5z"></path>
                                            </svg>
                                            <input class="d-none-cloaked" type="checkbox" name="order[]" id="id" value="id">
                                            <i class="switch-icon switch-icon-primary switch-icon-xs"></i>
                                            <span class="px-3 user-select-none">ID</span>
                                        </label>
                                    </div>
                                    <div class="list-group-item py-0">
                                        <label class="d-flex align-items-center">
                                            <svg width="16px" height="16px" xmlns="http://www.w3.org/2000/svg" fill="currentColor" class="bi bi-arrow-down-up me-1" viewBox="0 0 16 16">
                                                <path fill-rule="evenodd" d="M11.5 15a.5.5 0 0 0 .5-.5V2.707l3.146 3.147a.5.5 0 0 0 .708-.708l-4-4a.5.5 0 0 0-.708 0l-4 4a.5.5 0 1 0 .708.708L11 2.707V14.5a.5.5 0 0 0 .5.5zm-7-14a.5.5 0 0 1 .5.5v11.793l3.146-3.147a.5.5 0 0 1 .708.708l-4 4a.5.5 0 0 1-.708 0l-4-4a.5.5 0 0 1 .708-.708L4 13.293V1.5a.5.5 0 0 1 .5-.5z"></path>
                                            </svg>
                                            <input class="d-none-cloaked" type="checkbox" name="order[]" id="nome" value="nome">
                                            <i class="switch-icon switch-icon-primary switch-icon-xs"></i>
                                            <span class="px-3 user-select-none">Nome</span>
                                        </label>
                                    </div>
                                    <div class="list-group-item py-0">
                                        <label class="d-flex align-items-center">
                                            <svg width="16px" height="16px" xmlns="http://www.w3.org/2000/svg" fill="currentColor" class="bi bi-arrow-down-up me-1" viewBox="0 0 16 16">
                                                <path fill-rule="evenodd" d="M11.5 15a.5.5 0 0 0 .5-.5V2.707l3.146 3.147a.5.5 0 0 0 .708-.708l-4-4a.5.5 0 0 0-.708 0l-4 4a.5.5 0 1 0 .708.708L11 2.707V14.5a.5.5 0 0 0 .5.5zm-7-14a.5.5 0 0 1 .5.5v11.793l3.146-3.147a.5.5 0 0 1 .708.708l-4 4a.5.5 0 0 1-.708 0l-4-4a.5.5 0 0 1 .708-.708L4 13.293V1.5a.5.5 0 0 1 .5-.5z"></path>
                                            </svg>
                                            <input class="d-none-cloaked" type="checkbox" name="order[]" id="rg" value="rg">
                                            <i class="switch-icon switch-icon-primary switch-icon-xs"></i>
                                            <span class="px-3 user-select-none">Rg</span>
                                        </label>
                                    </div>
                                    <div class="list-group-item py-0">
                                        <label class="d-flex align-items-center">
                                            <svg width="16px" height="16px" xmlns="http://www.w3.org/2000/svg" fill="currentColor" class="bi bi-arrow-down-up me-1" viewBox="0 0 16 16">
                                                <path fill-rule="evenodd" d="M11.5 15a.5.5 0 0 0 .5-.5V2.707l3.146 3.147a.5.5 0 0 0 .708-.708l-4-4a.5.5 0 0 0-.708 0l-4 4a.5.5 0 1 0 .708.708L11 2.707V14.5a.5.5 0 0 0 .5.5zm-7-14a.5.5 0 0 1 .5.5v11.793l3.146-3.147a.5.5 0 0 1 .708.708l-4 4a.5.5 0 0 1-.708 0l-4-4a.5.5 0 0 1 .708-.708L4 13.293V1.5a.5.5 0 0 1 .5-.5z"></path>
                                            </svg>
                                            <input class="d-none-cloaked" type="checkbox" name="order[]" id="email" value="email">
                                            <i class="switch-icon switch-icon-primary switch-icon-xs"></i>
                                            <span class="px-3 user-select-none">e-mail</span>
                                        </label>
                                    </div>
                                    <div class="list-group-item py-0">
                                        <label class="d-flex align-items-center">
                                            <svg width="16px" height="16px" xmlns="http://www.w3.org/2000/svg" fill="currentColor" class="bi bi-arrow-down-up me-1" viewBox="0 0 16 16">
                                                <path fill-rule="evenodd" d="M11.5 15a.5.5 0 0 0 .5-.5V2.707l3.146 3.147a.5.5 0 0 0 .708-.708l-4-4a.5.5 0 0 0-.708 0l-4 4a.5.5 0 1 0 .708.708L11 2.707V14.5a.5.5 0 0 0 .5.5zm-7-14a.5.5 0 0 1 .5.5v11.793l3.146-3.147a.5.5 0 0 1 .708.708l-4 4a.5.5 0 0 1-.708 0l-4-4a.5.5 0 0 1 .708-.708L4 13.293V1.5a.5.5 0 0 1 .5-.5z"></path>
                                            </svg>
                                            <input class="d-none-cloaked" type="checkbox" name="order[]" id="cpf" value="cpf">
                                            <i class="switch-icon switch-icon-primary switch-icon-xs"></i>
                                            <span class="px-3 user-select-none">Cpf</span>
                                        </label>
                                    </div>
                                    <div class="list-group-item py-0">
                                        <label class="d-flex align-items-center">
                                            <svg width="16px" height="16px" xmlns="http://www.w3.org/2000/svg" fill="currentColor" class="bi bi-arrow-down-up me-1" viewBox="0 0 16 16">
                                                <path fill-rule="evenodd" d="M11.5 15a.5.5 0 0 0 .5-.5V2.707l3.146 3.147a.5.5 0 0 0 .708-.708l-4-4a.5.5 0 0 0-.708 0l-4 4a.5.5 0 1 0 .708.708L11 2.707V14.5a.5.5 0 0 0 .5.5zm-7-14a.5.5 0 0 1 .5.5v11.793l3.146-3.147a.5.5 0 0 1 .708.708l-4 4a.5.5 0 0 1-.708 0l-4-4a.5.5 0 0 1 .708-.708L4 13.293V1.5a.5.5 0 0 1 .5-.5z"></path>
                                            </svg>
                                            <input class="d-none-cloaked" type="checkbox" name="order[]" id="campoextra1" value="campoextra1">
                                            <i class="switch-icon switch-icon-primary switch-icon-xs"></i>
                                            <span class="px-3 user-select-none">Campo Extra 1</span>
                                        </label>
                                    </div>
                                    <div class="list-group-item py-0">
                                        <label class="d-flex align-items-center">
                                            <svg width="16px" height="16px" xmlns="http://www.w3.org/2000/svg" fill="currentColor" class="bi bi-arrow-down-up me-1" viewBox="0 0 16 16">
                                                <path fill-rule="evenodd" d="M11.5 15a.5.5 0 0 0 .5-.5V2.707l3.146 3.147a.5.5 0 0 0 .708-.708l-4-4a.5.5 0 0 0-.708 0l-4 4a.5.5 0 1 0 .708.708L11 2.707V14.5a.5.5 0 0 0 .5.5zm-7-14a.5.5 0 0 1 .5.5v11.793l3.146-3.147a.5.5 0 0 1 .708.708l-4 4a.5.5 0 0 1-.708 0l-4-4a.5.5 0 0 1 .708-.708L4 13.293V1.5a.5.5 0 0 1 .5-.5z"></path>
                                            </svg>
                                            <input class="d-none-cloaked" type="checkbox" name="order[]" id="campoextra2" value="campoextra2">
                                            <i class="switch-icon switch-icon-primary switch-icon-xs"></i>
                                            <span class="px-3 user-select-none">Campo Extra 2</span>
                                        </label>
                                    </div>
                                    <div class="list-group-item py-0">
                                        <label class="d-flex align-items-center">
                                            <svg width="16px" height="16px" xmlns="http://www.w3.org/2000/svg" fill="currentColor" class="bi bi-arrow-down-up me-1" viewBox="0 0 16 16">
                                                <path fill-rule="evenodd" d="M11.5 15a.5.5 0 0 0 .5-.5V2.707l3.146 3.147a.5.5 0 0 0 .708-.708l-4-4a.5.5 0 0 0-.708 0l-4 4a.5.5 0 1 0 .708.708L11 2.707V14.5a.5.5 0 0 0 .5.5zm-7-14a.5.5 0 0 1 .5.5v11.793l3.146-3.147a.5.5 0 0 1 .708.708l-4 4a.5.5 0 0 1-.708 0l-4-4a.5.5 0 0 1 .708-.708L4 13.293V1.5a.5.5 0 0 1 .5-.5z"></path>
                                            </svg>
                                            <input class="d-none-cloaked" type="checkbox" name="order[]" id="categoria" value="categoria">
                                            <i class="switch-icon switch-icon-primary switch-icon-xs"></i>
                                            <span class="px-3 user-select-none">Categoria (nome)</span>
                                        </label>
                                    </div>
                                    <div class="list-group-item py-0">
                                        <label class="d-flex align-items-center">
                                            <svg width="16px" height="16px" xmlns="http://www.w3.org/2000/svg" fill="currentColor" class="bi bi-arrow-down-up me-1" viewBox="0 0 16 16">
                                                <path fill-rule="evenodd" d="M11.5 15a.5.5 0 0 0 .5-.5V2.707l3.146 3.147a.5.5 0 0 0 .708-.708l-4-4a.5.5 0 0 0-.708 0l-4 4a.5.5 0 1 0 .708.708L11 2.707V14.5a.5.5 0 0 0 .5.5zm-7-14a.5.5 0 0 1 .5.5v11.793l3.146-3.147a.5.5 0 0 1 .708.708l-4 4a.5.5 0 0 1-.708 0l-4-4a.5.5 0 0 1 .708-.708L4 13.293V1.5a.5.5 0 0 1 .5-.5z"></path>
                                            </svg>
                                            <input class="d-none-cloaked" type="checkbox" name="order[]" id="id_categoria" value="id_categoria">
                                            <i class="switch-icon switch-icon-primary switch-icon-xs"></i>
                                            <span class="px-3 user-select-none">Categoria (id)</span>
                                        </label>
                                    </div>
                                    <div class="list-group-item py-0">
                                        <label class="d-flex align-items-center">
                                            <svg width="16px" height="16px" xmlns="http://www.w3.org/2000/svg" fill="currentColor" class="bi bi-arrow-down-up me-1" viewBox="0 0 16 16">
                                                <path fill-rule="evenodd" d="M11.5 15a.5.5 0 0 0 .5-.5V2.707l3.146 3.147a.5.5 0 0 0 .708-.708l-4-4a.5.5 0 0 0-.708 0l-4 4a.5.5 0 1 0 .708.708L11 2.707V14.5a.5.5 0 0 0 .5.5zm-7-14a.5.5 0 0 1 .5.5v11.793l3.146-3.147a.5.5 0 0 1 .708.708l-4 4a.5.5 0 0 1-.708 0l-4-4a.5.5 0 0 1 .708-.708L4 13.293V1.5a.5.5 0 0 1 .5-.5z"></path>
                                            </svg>
                                            <input class="d-none-cloaked" type="checkbox" name="order[]" id="situacao" value="situacao">
                                            <i class="switch-icon switch-icon-primary switch-icon-xs"></i>
                                            <span class="px-3 user-select-none">Status (Ativo)</span>
                                        </label>
                                    </div>
                                    <div class="list-group-item py-0">
                                        <label class="d-flex align-items-center">
                                            <svg width="16px" height="16px" xmlns="http://www.w3.org/2000/svg" fill="currentColor" class="bi bi-arrow-down-up me-1" viewBox="0 0 16 16">
                                                <path fill-rule="evenodd" d="M11.5 15a.5.5 0 0 0 .5-.5V2.707l3.146 3.147a.5.5 0 0 0 .708-.708l-4-4a.5.5 0 0 0-.708 0l-4 4a.5.5 0 1 0 .708.708L11 2.707V14.5a.5.5 0 0 0 .5.5zm-7-14a.5.5 0 0 1 .5.5v11.793l3.146-3.147a.5.5 0 0 1 .708.708l-4 4a.5.5 0 0 1-.708 0l-4-4a.5.5 0 0 1 .708-.708L4 13.293V1.5a.5.5 0 0 1 .5-.5z"></path>
                                            </svg>
                                            <input class="d-none-cloaked" type="checkbox" name="order[]" id="leitura" value="leitura">
                                            <i class="switch-icon switch-icon-primary switch-icon-xs"></i>
                                            <span class="px-3 user-select-none">Primeiro acesso (datetime)</span>
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card-footer border-light">
                    <button type="submit" class="btn btn-primary">
                        <svg width="18px" height="18px" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <polyline points="20 6 9 17 4 12"></polyline>
                        </svg>
                        <span>Exportar</span>
                    </button>
                </div>
            </div>
        </div>
    </div>
</form>
<?php $this->endsection(); ?>
<?php $this->section('scripts'); ?>
<script src="<?php echo base_url(); ?>/assets/js/vendor.sortable.js"></script>
<?php $this->endsection(); ?>