<?php $this->extend('layout/app'); ?>

<?php $this->section('header'); ?>
<title>Configuração da base</title>
<?php $this->endsection(); ?>
<?php $this->section('main'); ?>

<div class="section p-xl-4">

    <div class="d-flex">
        <div class="me-4 d-none d-md-block">
            <svg width="160px" height="160px" xmlns="http://www.w3.org/2000/svg" fill="currentColor" class="bi bi-server" viewBox="0 0 16 16">
                <path d="M1.333 2.667C1.333 1.194 4.318 0 8 0s6.667 1.194 6.667 2.667V4c0 1.473-2.985 2.667-6.667 2.667S1.333 5.473 1.333 4V2.667z"></path>
                <path d="M1.333 6.334v3C1.333 10.805 4.318 12 8 12s6.667-1.194 6.667-2.667V6.334a6.51 6.51 0 0 1-1.458.79C11.81 7.684 9.967 8 8 8c-1.966 0-3.809-.317-5.208-.876a6.508 6.508 0 0 1-1.458-.79z"></path>
                <path d="M14.667 11.668a6.51 6.51 0 0 1-1.458.789c-1.4.56-3.242.876-5.21.876-1.966 0-3.809-.316-5.208-.876a6.51 6.51 0 0 1-1.458-.79v1.666C1.333 14.806 4.318 16 8 16s6.667-1.194 6.667-2.667v-1.665z"></path>
            </svg>
        </div>
        <div class="w-100 position-relative">
            <h5>
                <span class="fw-bold">Plataforma One de Credenciamento e Controle de acesso</span>
            </h5>

            <div class="d-xl-flex">
                <div class="border border-dashed p-3 rounded w-100 max-w-300 me-2 mb-3">
                    <div class="d-flex align-items-center">
                        <div class="w-100 me-4 pe-3 border-end">
                            <h4 class="mb-0" id="total-ticket">---</h4>
                            <p class="mb-0 text-muted">Tickets</p>
                        </div>
                        <div class="w-100 me-4">
                            <h4 class="mb-0" id="total-register">---</h4>
                            <p class="mb-0 text-muted">Leituras</p>
                        </div>
                    </div>
                </div>
                <div class="border border-dashed p-3 rounded w-100 max-w-300 me-2 mb-3">
                    <div class="d-flex align-items-center">
                        <div class="w-100 me-4 pe-3 border-end">
                            <h4 class="mb-0" id="total-distinct-register">---</h4>
                            <p class="mb-0 text-muted">Leituras únicas</p>
                        </div>
                        <div class="flex-none text-end">
                            <a href="#" class="btn btn-sm btn-primary">Relatórios</a>
                        </div>
                    </div>
                </div>
            </div>
            <h6>Tickets válidos <span id="total-active-ticket">---</span> (<span id="percent">---</span>%)</h6>
            <div class="progress" style="height:5px">
                <div class="progress-bar" id="pgbar" role="progressbar" style="width: 0" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100"></div>
            </div>
        </div>
    </div>
</div>

<div class="section p-xl-4">
    <h3 class="h5 mb-2">Suporte</h3>
    <div class="d-flex justify-content-between">
        <button type="button" id="act-clear-register" class="btn btn-sm btn-primary">Limpar leituras</button>
        <span class="d-flex fw-medium align-items-center ">Apagar todo o registro de leituras</span>
    </div>
    <div class="border border-dashed border-bottom-0 my-3">
        <!-- divider -->
    </div>
    <div class="d-flex justify-content-between">
        <button type="button" id="act-change-status" class="btn btn-sm btn-primary">Alterar Status</button>
        <span class="d-flex fw-medium align-items-center ">Habilita ou desabilita tickets por evento/categoria</span>
    </div>
    <div class="border border-dashed border-bottom-0 my-3">
        <!-- divider -->
    </div>
    <div class="d-flex justify-content-between">
        <button type="button" id="act-clear-ticket" class="btn btn-sm btn-primary">Excluir Tickets</button>
        <span class="d-flex fw-medium align-items-center ">Remove todos os tickets da base de dados, por evento /categoria</span>
    </div>
    <div class="border border-dashed border-bottom-0 my-3">
        <!-- divider -->
    </div>
    <div class="d-flex justify-content-between">
        <button type="button" id="act-clear-database" class="btn btn-sm btn-primary">Zerar Base</button>
        <span class="d-flex fw-medium align-items-center ">Exclui todos os dados, tickets, leitura, evento, categorias, marcações e usuários</span>
    </div>
    <div class="border border-dashed border-bottom-0 my-3">
        <!-- divider -->
    </div>
    <div class="border border-dashed border-bottom-0 my-3">
        <!-- divider -->
    </div>
</div>

<!-- Modal -->
<div class="modal fade" id="modalAccept" tabindex="-1" role="dialog" aria-labelledby="modalAcceptLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">

            <div class="modal-header">
                <h5 class="modal-title" id="modalAcceptLabel">Confirma decisão</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                <input type="hidden" id="act" name="act" value="" />
            </div>

            <div class="modal-body" id="modalAcceptBody">
                ...
            </div>
            <div class="modal-body" id="modalSelects">
                <div class="row">
                    <div class="col-lg-6">
                        <div class="form-floating">
                            <select class="form-select form-select-sm filters" require id="filter-event" name="id_evento">
                                <?php foreach ($events as $e) : ?>
                                    <option value="<?php echo $e->id; ?>"><?php echo $e->evento; ?></option>
                                <?php endforeach; ?>
                            </select>
                            <label for="filter-event" class="form-label">Evento</label>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="form-floating">
                            <select class="form-select form-select-sm filters" require id="filter-category" name="id_categoria">
                                <?php foreach ($categories as $ca) : ?>
                                    <option value="<?php echo $ca->id; ?>"><?php echo $ca->categoria; ?></option>
                                <?php endforeach; ?>
                            </select>
                            <label for="filter-category" class="form-label">Categoria</label>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-body" id="modalStatus">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="form-control">
                            <label class="d-flex align-items-center mb-1">
                                <input class="d-none-cloaked" type="checkbox" name="situacao" id="situacao" checked value="1">
                                <i class="switch-icon switch-icon-primary switch-icon-xs"></i>
                                <span class="px-3 user-select-none">Ticket Ativo</span>
                            </label>
                        </div>
                    </div>
                </div>
            </div>

            <div class="modal-footer">
                <button type="button" id="act-send" class="btn btn-danger">
                    <i class="fi fi-check"></i>
                    Confirmar
                </button>
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                    <i class="fi fi-close"></i>
                    Cancelar
                </button>
            </div>

        </div>
    </div>
</div>
<?php $this->endsection(); ?>
<?php $this->section('scripts'); ?>
<script>
    $(document).ready(function() {
        const modalAccept = new bootstrap.Modal(document.getElementById('modalAccept'), {
            keyboard: false
        });
        $("#modalSelects").hide()
        $("#modalStatus").hide()
        loadData()
        $("#act-clear-register").click(()=>{
            $("#modalSelects").hide()
            $("#modalStatus").hide()
            $("#modalAcceptBody").html('<h4>Confirma exclusão de todos os registros de leitura?</h4><p>Esta operação não poderá ser desfeita</p>')
            $("#act").val('register')
            
            modalAccept.show();
        })
        $("#act-change-status").click(()=>{
            $("#modalSelects").show()
            $("#modalStatus").show()
            $("#modalAcceptBody").html('<h4>Alteração de status</h4><p>Esta operação não poderá ser desfeita</p>')
            $("#act").val('changestatus')
            
            modalAccept.show();
        })
        $("#act-clear-ticket").click(()=>{
            $("#modalSelects").show()
            $("#modalStatus").hide()
            $("#modalAcceptBody").html('<h4>Excluir Tickets</h4><p>Esta operação não poderá ser desfeita</p>')
            $("#act").val('removeticket')
            
            modalAccept.show();
        })
        $("#act-clear-database").click(()=>{
            $("#modalSelects").hide()
            $("#modalStatus").hide()
            $("#modalAcceptBody").html('<h4>Zerar a Base</h4>Excluir todos os dados!!!<p>Esta operação não poderá ser desfeita</p>')
            $("#act").val('removeAll')
            
            modalAccept.show();
        })

        $("#act-send").click(()=>{
            const act = $("#act").val()
            const id_evento = $("#filter-event").val()
            const id_categoria = $("#filter-category").val()
            const situacao = $("#situacao").is(':checked')?1:0
            const data = {
                act, id_evento, id_categoria, situacao
            }
            $.post('<?php echo base_url(); ?>/manage/database', data, (response)=>{
                modalAccept.hide();
                console.log(response)
                loadData()
            })

        })

        function loadData() {
            $.get('<?php echo base_url(); ?>/manage/database/data',  (response)=>{
                $("#total-ticket").html(response.totalTickets)
                $("#total-register").html(response.totalRegister)
                $("#total-distinct-register").html(response.totalDistinctRegister)
                $("#total-active-ticket").html(response.totalActiveTickets)
                $("#percent").html(response.percent)
                $("#pgbar").css('width',`${response.percent}%`)
            })
        }
    })
    
</script>
<?php $this->endsection(); ?>