<?php $this->extend('layout/app'); ?>

<?php $this->section('header'); ?>
<title>Integração de Ticketeiras</title>
<?php $this->endsection(); ?>
<?php $this->section('main'); ?>

<form class="form-validate" method="post" action="<?php echo base_url() . '/integration' . (!empty($integration->id) ? "/{$integration->id}" : ""); ?>" id="form-integration">
    <div class="row g-4">
        <!-- side -->
        <div class="">
            <div class="section">
                <div class="h5 card-header border-bottom-0 fw-bold">Integração de Ticketeiras</div>
                <div class="card-body">
                    <div class="row g-3 mb-3">
                        <div class="col-lg-6">
                            <div class="form-floating">
                                <select class="form-select form-select-sm filters" id="evento_id" name="evento_id">
                                    <?php foreach ($events as $event) : ?>
                                        <option value="<?php echo $event->id; ?>" <?php echo $integration->evento_id == $event->id ? "selected" : ""; ?>><?php echo $event->evento; ?></option>
                                    <?php endforeach; ?>
                                </select>
                                <label for="tipo" class="form-label">Evento</label>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="form-floating">
                                <select class="form-select form-select-sm filters" id="ticketeira_id" name="ticketeira_id">
                                    <?php foreach ($ticketeiras as $ticketeira) : ?>
                                        <option value="<?php echo $ticketeira->id; ?>" <?php echo $integration->ticketeira_id == $ticketeira->id ? "selected" : ""; ?>><?php echo $ticketeira->nome; ?></option>
                                    <?php endforeach; ?>
                                </select>
                                <label for="tipo" class="form-label">Ticketeira</label>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="form-floating">
                                <input required type="text" class="form-control" id="token" name="token" placeholder="Token" value="<?php echo $integration->token; ?>">
                                <label for="token">Token</label>
                            </div>
                        </div>
                        <div class="col-lg-4">
                            <div class="form-floating">
                                <input required type="text" class="form-control" id="identify" name="identify" placeholder="identify" value="<?php echo $integration->identify; ?>">
                                <label for="token"><strong>ID</strong>entify</label>
                            </div>
                        </div>
                        <div class="col-lg-2">
                            <label class="d-flex align-items-center mb-3">
                                <input class="d-none-cloaked" type="checkbox" name="active" id="active" value="1" <?php echo $integration->active == '1' ? 'checked=""' : ''; ?>>
                                <em class="switch-icon switch-icon-primary switch-icon-xs"></em>
                                <span class="px-3 user-select-none">Ativo</span>
                            </label>
                        </div>
                        <div class="col-lg-12">
                            <textarea class="form-control" rows="3" id="params" name="params" placeholder="{}"><?php echo $integration->params; ?></textarea>
                            <label for="params">Parâmetros (json)</label>
                        </div>
                        <div class="col-lg-3">
                            <div class="form-floating">
                                <input required type="text" class="form-control" id="ticket_serial_id" name="ticket_serial_id" placeholder="ticket serial" value="<?php echo $integration->ticket_serial_id; ?>">
                                <label for="ticket_serial_id">Serial do Ticket (auto)</label>
                            </div>
                        </div>
                        <div class="col-lg-3">
                            <div class="form-floating">
                                <input required type="text" class="form-control" id="registry_serial_id" name="registry_serial_id" placeholder="Registry serial" value="<?php echo $integration->registry_serial_id; ?>">
                                <label for="registry_serial_id">Serial da marcação (auto)</label>
                            </div>
                        </div>
                        <div class="col-lg-3">
                            <div class="form-floating">
                                <input required type="text" class="form-control" id="entrega_serial_id" name="entrega_serial_id" placeholder="Entrega serial" value="<?php echo $integration->entrega_serial_id; ?>">
                                <label for="entrega_serial_id">Serial da entrega (auto)</label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-footer border-light">
                    <a href="<?php echo base_url(); ?>/integration" class="btn btn-secondary">
                        <i class="fi fi-arrow-left"></i>
                        <span>Voltar</span>
                    </a>
                    <button type="submit" class="btn btn-primary">
                        <svg width="18px" height="18px" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <polyline points="20 6 9 17 4 12"></polyline>
                        </svg>
                        <span><?php echo $integration->id ? 'Salvar' : 'Criar Integração'; ?></span>
                    </button>
                    <?php if ($integration->id) { ?>
                        <button type="button" id="btn-remove" class="btn btn-danger">
                            <svg width="18px" height="18px" xmlns="http://www.w3.org/2000/svg" fill="currentColor" class="bi bi-x-circle" viewBox="0 0 16 16">
                                <path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14zm0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16z"></path>
                                <path d="M4.646 4.646a.5.5 0 0 1 .708 0L8 7.293l2.646-2.647a.5.5 0 0 1 .708.708L8.707 8l2.647 2.646a.5.5 0 0 1-.708.708L8 8.707l-2.646 2.647a.5.5 0 0 1-.708-.708L7.293 8 4.646 5.354a.5.5 0 0 1 0-.708z"></path>
                            </svg>
                            <span>Excluir</span>
                        </button>
                    <?php  } ?>
                </div>
            </div>
        </div>
    </div>
</form>
<?php $this->endsection(); ?>
<?php $this->section('scripts'); ?>
<script>
    $(document).ready(function() {
        //
    })
</script>
<?php $this->endsection(); ?>