
<!DOCTYPE html>
<html lang="en">
    <head>
        <?php echo view($templatepath . '/partial/_head'); ?>

    </head>
    <body>
        <?php echo view($templatepath . '/partial/header'); ?>
        <section>
            <?php echo view($templatepath . '/partial/sidebar'); ?>
            <div class="mainpanel">
                <div class="contentpanel">
                    <ol class="breadcrumb breadcrumb-quirk">
                        <li><a href="<?php echo base_url(); ?>"><i class="fa fa-home mr5"></i> Home</a></li>
                        <li><a href="<?php echo base_url() . '/grouppermission'; ?>">Grupos</a></li>
                        <li><a href="#">Itens</a></li>
                        <li class="active">List</li>
                    </ol>
                    <!-- content goes here... -->

                    <div class="panel">
                        <div class="panel-heading">
                            <h4 class="panel-title">Grupos</h4>
                            <div class="form-group mt10">
                                <h4><?php echo $grouppermission->id; ?> - <?php echo $grouppermission->name; ?></h4>
                            </div>

                        </div>
                        <div class="panel-body">
                            <div class="table-responsive">
                                <table id="tableRoute" class="table table-bordered table-striped table-hover">
                                    <thead class="">
                                        <tr>
                                            <th>ID</th>
                                            <th>Nome</th>
                                            <th>Metodo</th>
                                            <th>Rota</th>
                                            <th>Tipo</th>
                                            <th>Ativo</th>
                                            <th>&nbsp;</th>
                                        </tr>
                                    </thead>
                                    <tfoot>
                                        <tr>
                                            <th>ID</th>
                                            <th>Nome</th>
                                            <th>Metodo</th>
                                            <th>Rota</th>
                                            <th>Tipo</th>
                                            <th>Ativo</th>
                                            <th>&nbsp;</th>
                                        </tr>
                                    </tfoot>

                                    <tbody>
                                        <?php foreach ($items as $k => $v): ?>
                                            <tr>
                                                <td><?php echo $v->api_route_id; ?></td>
                                                <td><?php echo $v->name; ?></td>
                                                <td><?php echo $v->method; ?></td>
                                                <td><?php echo $v->route; ?></td>
                                                <td><?php echo $v->app_type_id; ?></td>
                                                <td><?php echo $v->active == 1 ? '<i class="fa fa-check"></i>' : '<i class="fa fa-times"></i>'; ?></td>
                                                <td>
                                                    <a  href="<?php echo base_url() . "/grouppermission/{$grouppermission->id}/permission/{$v->api_route_id}/"; ?>"
                                                        class="btnadded btn btn-sm <?php echo $v->added == '1' ? 'btn-primary' : 'btn-danger' ?>" 
                                                        data-permission="<?php echo $v->api_route_id; ?>"
                                                        data-grupo="<?php echo $grouppermission->id; ?>"
                                                        data-state="<?php echo $v->added == '1' ? 'remove' : 'add' ?>"
                                                        >
                                                        <i class="fa fa-<?php echo $v->added == '1' ? 'check' : 'times' ?>"></i>
                                                    </a>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div><!-- panel -->
                </div><!-- contentpanel -->
            </div><!-- mainpanel -->
        </section>
        <?php echo view($templatepath . '/partial/scripts'); ?>
        <script src="<?php echo base_url($templatepath); ?>/assets/lib/datatables/jquery.dataTables.js"></script>
        <script src="<?php echo base_url($templatepath); ?>/assets/lib/datatables-plugins/integration/bootstrap/3/dataTables.bootstrap.js"></script>
        <script src="<?php echo base_url($templatepath); ?>/assets/lib/select2/select2.js"></script>
        <script>
            $(document).ready(function() {
                $('#tableRoute').on('click','a.btnadded', function (e, settings) {
                    e.preventDefault();
                    const grupo = $(this).data('grupo')
                    const permission = $(this).data('permission')
                    const state = $(this).data('state')
                    const href = $(this).attr('href')
                    const obj = $(this)
                    obj.removeClass('btn-primary');
                    obj.removeClass('btn-danger');
                    obj.find('i').removeClass('fa-check fa-times fa-spinner fa-spin');
                    obj.find('i').addClass('fa-spinner fa-spin');
                    $.get(href+state, function(data){
                       if(data.status === true) {
                           obj.find('i').removeClass('fa-check fa-times fa-spinner fa-spin');
                           $.gritter.add({
                                title: 'Sucesso',
                                text: data.message,
                                class_name: 'with-icon check-circle success'
                            });
                            if(data.data ==='add') {
                                obj.data('state','remove')
                                obj.addClass('btn-primary');
                                obj.find('i').addClass('fa-check');
                            }
                            if(data.data ==='del') {
                                obj.data('state','add')
                                obj.addClass('btn-danger');
                                obj.find('i').addClass('fa-times');
                            }
                       } else {
                           obj.find('i').removeClass('fa-check fa-times fa-spinner fa-spin');
                           $.gritter.add({
                                title: 'Error',
                                text: data.message,
                                class_name: 'with-icon exclamation-circle danger'
                            });
                       }
                    });

                });
                var table = $('#tableRoute').dataTable({
                    pageLength: 15,
                    processing: true,
                    searchDelay: 350,
                    order: [
                        [0, "desc"]
                    ],
                    loadingMessage: 'Carregando...',
                    dom: '<"toolbar">frtip',
                    class: 'details-control',
                    columnDefs: [
                        {responsivePriority: 1, targets: 0},
                        {responsivePriority: 2, targets: 3}
                    ],
                    language: {
                        emptyTable: "Nenhum registro localizado.",
                        info: "Exibindo _START_ até _END_ de _TOTAL_ registros",
                        infoEmpty: "Exibindo 0 até 0 de 0 registros",
                        infoFiltered: "(filtrados de _MAX_ no total)",
                        infoPostFix: "",
                        thousands: ",",
                        lengthMenu: "Exibindo _MENU_ registros",
                        loadingRecords: "Carregando...",
                        processing: "Processando...",
                        search: "Busca Rota ",
                        zeroRecords: "Nenhum registro localizado.",
                        paginate: {
                            first: "Primeiro",
                            last: "Ultimo",
                            next: "Prox.",
                            previous: "Ant."
                        },
                        aria: {
                            sortAscending: ": activate to sort column ascending",
                            sortDescending: ": activate to sort column descending"
                        }
                    }
                });
            });
        </script>
    </body>
</html>
