
<!DOCTYPE html>
<html lang="en">
    <head>
        <?php echo view($templatepath . '/partial/_head'); ?>

    </head>
    <body>
        <?php echo view($templatepath . '/partial/header'); ?>
        <section>
            <?php echo view($templatepath . '/partial/sidebar'); ?>
            <div class="mainpanel">
                <div class="contentpanel">
                    <ol class="breadcrumb breadcrumb-quirk">
                        <li><a href="<?php echo base_url(); ?>"><i class="fa fa-home mr5"></i> Home</a></li>
                        <li><a href="<?php echo base_url() . '/grouppermission'; ?>">Grupos</a></li>
                        <li class="active">List</li>
                    </ol>
                    <!-- content goes here... -->

                    <div class="panel">
                        <div class="panel-heading">
                            <h4 class="panel-title">Grupos</h4>
                            <div class="form-group mt10">
                                <a href="<?php echo base_url() . '/grouppermission/add'; ?>" class="btn btn-sm btn-primary"><i class="fa fa-plus"></i> Novo grupo</a>
                            </div>

                        </div>
                        <div class="panel-body">
                            <div class="table-responsive">
                                <table id="tableRoute" class="table table-bordered table-striped table-hover">
                                    <thead class="">
                                        <tr>
                                            <th>ID</th>
                                            <th>Nome</th>
                                            <th>Ativo</th>
                                            <th>&nbsp;</th>
                                        </tr>
                                    </thead>
                                    <tfoot>
                                        <tr>
                                            <th>ID</th>
                                            <th>Nome</th>
                                            <th>Ativo</th>
                                            <th>&nbsp;</th>
                                        </tr>
                                    </tfoot>

                                    <tbody>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div><!-- panel -->
                </div><!-- contentpanel -->
            </div><!-- mainpanel -->
        </section>
        <?php echo view($templatepath . '/partial/scripts'); ?>
        <script src="<?php echo base_url($templatepath); ?>/assets/lib/datatables/jquery.dataTables.js"></script>
        <script src="<?php echo base_url($templatepath); ?>/assets/lib/datatables-plugins/integration/bootstrap/3/dataTables.bootstrap.js"></script>
        <script src="<?php echo base_url($templatepath); ?>/assets/lib/select2/select2.js"></script>
        <script>
            $(document).ready(function() {
                var table = $('#tableRoute').dataTable({
                    pageLength: 15,
                    searchDelay: 350,
                    order: [
                        [0, "desc"]
                    ],
                    ajax: {
                        "url": "<?php echo base_url($templatepath); ?>/grouppermission/data",
                        "data": function (d) {
                            var active = $('#filter-active').val();
                            return $.extend({}, d, {
                                active: active,
                            });
                        }
                    },
                    loadingMessage: 'Carregando...',
                    dom: '<"toolbar">frtip',
                    class: 'details-control',
                    columnDefs: [
                        {responsivePriority: 1, targets: 0},
                        {responsivePriority: 2, targets: 3}
                    ],
                    language: {
                        emptyTable: "Nenhum registro localizado.",
                        info: "Exibindo _START_ até _END_ de _TOTAL_ registros",
                        infoEmpty: "Exibindo 0 até 0 de 0 registros",
                        infoFiltered: "(filtrados de _MAX_ no total)",
                        infoPostFix: "",
                        thousands: ",",
                        lengthMenu: "Exibindo _MENU_ registros",
                        loadingRecords: "Carregando...",
                        processing: "Processando...",
                        search: "Busca Rota ",
                        zeroRecords: "Nenhum registro localizado.",
                        paginate: {
                            first: "Primeiro",
                            last: "Ultimo",
                            next: "Prox.",
                            previous: "Ant."
                        },
                        aria: {
                            sortAscending: ": activate to sort column ascending",
                            sortDescending: ": activate to sort column descending"
                        }
                    }
                });
            });
        </script>
    </body>
</html>
