<?php $this->extend('layout/app'); ?>

<?php $this->section('header'); ?>
<title>Grupo</title>
<?php $this->endsection(); ?>
<?php $this->section('main'); ?>

<form class="form-validate" method="post" action="<?php echo base_url() . '/group' . (!empty($group->id) ? "/{$group->id}" : ""); ?>" id="form-group">
    <div class="row g-4">
        <!-- side -->
        <div class="">
            <div class="section">
                <div class="h5 card-header border-bottom-0 fw-bold">Grupo</div>
                <div class="card-body">
                    <div class="row g-3 mb-3">
                        <div class="col">
                            <div class="form-floating">
                                <input required type="text" readonly class="form-control" id="nome_grupo_categoria" name="nome_grupo_categoria" placeholder="Nome do Grupo" value="<?php echo $group->nome_grupo_categoria;?>">
                                <label for="nome_grupo_categoria">Nome do Grupo</label>
                            </div>
                        </div>
                    </div>
                </div>
                <?php if(!empty($group->id)): ?>
                    <div class="card-body">
                        <div class="row g-3 mb-3">
                            <div class="col">
                                <table class="table table-sm table-striped" role="grid" aria-describedby="mobile-page-info">
                                    <thead>
                                        <tr>
                                            <th class="small text-muted">Categoria</th>
                                            <th class="small text-muted">Ativo</th>
                                        </tr>
                                    </thead>
                                    <tbody id="checkall-list">
                                    <?php foreach($groupItems as $item): ?>
                                        <tr>
                                            <td><?php echo $item->categoria; ?></td>
                                            <td>
                                                <label class="d-flex align-items-center">
                                                    <input class="d-none-cloaked xcategory" type="checkbox" name="ativo" data-category="<?php echo $item->id; ?>" id="ativo-<?php echo $item->id; ?>" value="1" <?php echo $item->active == '1' ? 'checked=""' : ''; ?>>
                                                    <em class="switch-icon switch-icon-primary switch-icon-xs"></em>
                                                    <span class="px-3 user-select-none">Ativo</span>
                                                </label>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
                <div class="card-footer border-light">
                    <a href="<?php echo base_url(); ?>/group" class="btn btn-secondary">
                        <i class="fi fi-arrow-left"></i>
                        <span>Voltar</span>
                    </a>
                </div>
            </div>
        </div>
    </div>
</form>
<?php $this->endsection(); ?>
<?php $this->section('scripts'); ?>
<script>
    $(document).ready(function() {
        $('.xcategory').click(function(){
            const sw = $(this)
            const data = {
                'group': <?php echo intval($group->id); ?>,
                'category': sw.data('category'),
                'sts': sw[0].checked?1:0
            }
            
            $.post('<?php echo base_url(); ?>/group/<?php echo $group->id;?>/category', data, (response)=>{
                sw[0].checked=response.sts==1?true:false
            })
        })
    })
</script>
<?php $this->endsection(); ?>