<?php $this->extend('layout/app'); ?>

<?php $this->section('header'); ?>
<title>Eventos</title>
<?php $this->endsection(); ?>
<?php $this->section('main'); ?>

<!-- user list -->
<div class="section p-0">
    <div class="card-header p-4">

        <div class="row g-3">

            <!-- review filter -->
            <div class="order-2 order-md-1 col">
                <div class="w-100">
                    <h2 class="h5 mb-0">Cadastro de Eventos</h2>
                </div>
            </div>

            <!-- options -->
            <div class="order-1 order-md-2 col-md-auto">
                <a href="<?php echo base_url() . '/event/add'; ?>" class="w-100 btn btn-sm btn-primary">
                    <svg width="18px" height="18px" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <line x1="12" y1="5" x2="12" y2="19"></line>
                        <line x1="5" y1="12" x2="19" y2="12"></line>
                    </svg>
                    <span>Novo evento</span>
                </a>
            </div>
            <div class="order-1 order-md-2 col-md-auto">
                <button class="w-100 btn btn-sm btn-secondary" id="add-sympla">
                    <svg width="18px" height="18px" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <line x1="12" y1="5" x2="12" y2="19"></line>
                        <line x1="5" y1="12" x2="19" y2="12"></line>
                    </svg>
                    <span>Importa Simpla</span>
                </button>
            </div>

        </div>

    </div>

    <div class="card-body pt-1">

        <!-- item list -->
        <div class="table-responsive-md">

            <table class="table table-align-middle" role="grid" aria-describedby="mobile-page-info">
                <thead>
                    <tr>
                        <th style="width:46px">
                            <div class="form-check">
                                ID
                            </div>
                        </th>
                        <th class="small text-muted">EVENTO</th>
                        <th class="small text-muted">CODE</th>
                        <th class="small text-muted">INÍCIO</th>
                        <th class="small text-muted">FIM</th>
                        <th class="small text-muted">
                            <!-- options -->
                        </th>
                    </tr>
                </thead>
                <tbody id="checkall-list">

                    <!-- item -->
                    <?php foreach ($events as $k => $event) : ?>
                        <tr>
                            <th>
                                <span class="d-block text-muted small"><?php echo $event->id; ?></span>
                            </th>
                            <td>
                                <!-- user -->
                                <div class="d-flex align-items-center">
                                    <div class="avatar avatar-sm rounded-circle" style="background-image:url(../html_frontend/demo.files/images/avatar/jessica_barden.jpg)"></div>
                                    <div class="ms-3">
                                        <a href="<?php echo base_url() . '/event/' . $event->id;?>" class="link-normal fw-medium"><?php echo $event->evento; ?></a>
                                        <small class="d-block"><?php echo $event->local; ?></small>
                                    </div>
                                </div>
                            </td>
                            <td>
                                <span class="d-flex align-items-center"><?php echo $event->code; ?></span>
                            </td>
                            <td>
                                <span class="d-flex align-items-center"><?php echo date('d/m/Y H:i:s', strtotime($event->data_inicio)); ?></span>
                            </td>
                            <td class="text-center">
                                <span class="d-flex align-items-center"><?php echo date('d/m/Y H:i:s', strtotime($event->data_fim)); ?></span>
                            </td>
                            <td class="dropstart text-end">
                                <!-- options -->
                                <a class="btn btn-sm btn-light btn-ghost btn-icon text-muted rounded-circle" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                                    <span class="group-icon">
                                        <svg width="18px" height="18px" viewBox="0 0 16 16" xmlns="http://www.w3.org/2000/svg" fill="currentColor">
                                            <path fill-rule="evenodd" d="M9.5 13a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0zm0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0zm0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0z"></path>
                                        </svg>
                                        <svg xmlns="http://www.w3.org/2000/svg" width="18px" height="18px" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                            <line x1="18" y1="6" x2="6" y2="18"></line>
                                            <line x1="6" y1="6" x2="18" y2="18"></line>
                                        </svg>
                                    </span>
                                </a>
                                <ul class="dropdown-menu dropdown-menu-clean">
                                    <li class="small px-3 py-2 text-muted">Opções</li>
                                    <li>
                                        <a class="dropdown-item" href="<?php echo base_url() . '/event/' . $event->id;?>">
                                            <svg class="text-muted" width="18px" height="18px" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                                <polyline points="20 6 9 17 4 12"></polyline>
                                            </svg>
                                            <span>Editar</span>
                                        </a>
                                    </li>
                                    <!-- <li>
                                        <a class="dropdown-item" href="#">
                                            <svg class="text-muted" width="18px" height="18px" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                                <line x1="18" y1="6" x2="6" y2="18"></line>
                                                <line x1="6" y1="6" x2="18" y2="18"></line>
                                            </svg>
                                            <span>Relatórios</span>
                                        </a>
                                    </li>
                                    <li>
                                        <a class="dropdown-item" href="#">
                                            <svg class="text-muted" width="18px" height="18px" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                                <line x1="18" y1="6" x2="6" y2="18"></line>
                                                <line x1="6" y1="6" x2="18" y2="18"></line>
                                            </svg>
                                            <span>Acessos</span>
                                        </a>
                                    </li> -->
                                </ul>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Modal -->
<div class="modal fade" id="modalImportaSympla" tabindex="-1" role="dialog" aria-labelledby="modalImportaSymplaLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">

            <div class="modal-header">
                <h5 class="modal-title" id="modalImportaSymplaLabel">Importar evento sympla</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                <input type="hidden" id="act" name="act" value="" />
            </div>

            <div class="modal-body" id="modalImportaSymplaBody">
                <div class="row pb-2">
                    <div class="col-lg-12">
                        <div class="form-floating">
                            <textarea required type="text" class="form-control" id="sympla-token" name="sympla-token" placeholder="Token"></textarea>
                            <label for="evento">Token sympla</label>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-12">
                        <div class="form-floating">
                            <input required type="number" class="form-control" id="sympla-event-id" name="sympla-event-id" placeholder="ID do Evento" value="">
                            <label for="evento">ID do evento sympla</label>
                        </div>
                    </div>
                </div>

            <div class="modal-footer">
                <button type="button" id="act-send" class="btn btn-danger">
                    <i class="fi fi-check"></i>
                    Confirmar
                </button>
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                    <i class="fi fi-close"></i>
                    Cancelar
                </button>
            </div>

        </div>
    </div>
</div>
<!-- /widgets -->
<?php $this->endsection(); ?>
<?php $this->section('scripts'); ?>
<script>
    $(document).ready(function() {
        const modalImportaSympla = new bootstrap.Modal(document.getElementById('modalImportaSympla'), {
            keyboard: false
        });
        $("#add-sympla").click(()=>{
            modalImportaSympla.show();
        })

        $("#act-send").click(()=>{
            const token = $("#sympla-token").val()
            const eventId = $("#sympla-event-id").val()
            const data = {
                token, eventId
            }
            $.post('<?php echo base_url(); ?>/event/sympla', data, (response)=>{
                modalAccept.hide();
                console.log(response)
            })

        })
    })
</script>
<?php $this->endsection(); ?>