<?php $this->extend('layout/app'); ?>

<?php $this->section('header'); ?>
<title>Evento</title>
<?php $this->endsection(); ?>
<?php $this->section('main'); ?>

<form class="form-validate" method="post" action="<?php echo base_url() . '/event' . (!empty($event->id) ? "/{$event->id}" : ""); ?>" id="form-event">
    <div class="row g-4">
        <!-- side -->
        <div class="">
            <div class="section">
                <div class="h5 card-header border-bottom-0 fw-bold">Evento</div>
                <div class="card-body">
                    <div class="row g-3 mb-3">
                        <div class="col-lg-5">
                            <div class="form-floating">
                                <input required type="text" class="form-control" id="evento" name="evento" placeholder="Evento" value="<?php echo $event->evento;?>">
                                <label for="evento">Evento</label>
                            </div>
                        </div>
                        <div class="col-lg-2">
                            <div class="form-floating">
                                <input required type="text" class="form-control" id="code" name="code" placeholder="Code" value="<?php echo $event->code;?>">
                                <label for="local">Code</label>
                            </div>
                        </div>
                        <div class="col-lg-5">
                            <div class="form-floating">
                                <input required type="text" class="form-control" id="local" name="local" placeholder="Local" value="<?php echo $event->local;?>">
                                <label for="local">Local</label>
                            </div>
                        </div>
                    </div>
                    <div class="row g-3 mb-3">
                        <div class="col-lg-6">
                            <div class="form-floating">
                                <input required type="datetime-local" class="form-control" id="data_inicio" name="data_inicio" placeholder="Data de início" value="<?php echo $event->data_inicio??'';?>">
                                <label for="data_inicio">Início</label>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="form-floating">
                                <input required type="datetime-local" class="form-control" id="data_fim" name="data_fim" placeholder="Data de encerramento" value="<?php echo $event->data_fim??'';?>">
                                <label for="data_fim">Fim</label>
                            </div>
                        </div>
                    </div>
                    <div class="row g-3 mb-3">
                        <div class="col-lg-6">
                            <div class="form-floating">
                                <input type="text" class="form-control" id="campoextra1" name="campoextra1" placeholder="Campo extra 1" value="<?php echo $event->campoextra1;?>">
                                <label for="campoextra1">Campo extra 1</label>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="form-floating">
                                <input type="text" class="form-control" id="campoextra2" name="campoextra2" placeholder="Campo extra 2" value="<?php echo $event->campoextra2;?>">
                                <label for="campoextra2">Campo extra 2</label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-footer border-light">
                    <a href="<?php echo base_url(); ?>/event" class="btn btn-secondary">
                        <i class="fi fi-arrow-left"></i>
                        <span>Voltar</span>
                    </a>
                    <button type="submit" class="btn btn-primary">
                        <svg width="18px" height="18px" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <polyline points="20 6 9 17 4 12"></polyline>
                        </svg>
                        <span><?php echo $event->id?'Salvar':'Criar evento'; ?></span>
                    </button>
                    <?php if ($event->id) { ?>
                        <button type="button" id="btn-remove" class="btn btn-danger">
                            <svg width="18px" height="18px" xmlns="http://www.w3.org/2000/svg" fill="currentColor" class="bi bi-x-circle" viewBox="0 0 16 16">
                                <path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14zm0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16z"></path>
                                <path d="M4.646 4.646a.5.5 0 0 1 .708 0L8 7.293l2.646-2.647a.5.5 0 0 1 .708.708L8.707 8l2.647 2.646a.5.5 0 0 1-.708.708L8 8.707l-2.646 2.647a.5.5 0 0 1-.708-.708L7.293 8 4.646 5.354a.5.5 0 0 1 0-.708z"></path>
                            </svg>
                            <span>Excluir</span>
                        </button>
                    <?php  } ?>
                </div>
            </div>
        </div>
    </div>
</form>
<div class="modal fade" id="modalRemove" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabelSm" aria-hidden="true">
    <div class="modal-dialog modal-sm" role="document">
        <div class="modal-content">

            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabelSm">Remover Evento</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>

            <div class="modal-body">
                Confirma a exclusão deste evento? confirmando, esta operação não poderá ser desfeita!
            </div>

            <div class="modal-footer">
                <button type="button" id="act-remove" class="btn btn-sm btn-warning">
                    <i class="fi fi-check"></i>
                    Confirmar
                </button>
                <button type="button" class="btn btn-sm btn-secondary" data-bs-dismiss="modal">
                    <i class="fi fi-close"></i>
                    Fechar
                </button>
                

            </div>

        </div>
    </div>
</div>
<?php $this->endsection(); ?>
<?php $this->section('scripts'); ?>
<script>
    $(document).ready(function() {
        $("#btn-remove").click(() => {
            $('#modalRemove').modal('show')
        })
        <?php if ($event->id) { ?>
            $("#act-remove").click(() => {
                window.location.href = '<?php echo base_url(); ?>/event/delete/<?php echo $event->id; ?>'
            })
        <?php } ?>
    })
</script>
<?php $this->endsection(); ?>