<?php $this->extend('layout/app'); ?>

<?php $this->section('header'); ?>
<title>Terminais</title>
<?php $this->endsection(); ?>
<?php $this->section('main'); ?>

<div class="section p-0">
    <div class="card-header p-4">
        <div class="row g-3">
            <div class="order-2 order-md-1 col">
                <div class="w-100">
                    <h2 class="h5 mb-0">Cadastro de Monitor de Acesso (Credenciamento)</h2>
                </div>
            </div>
        </div>
    </div>
    <div class="card-body pt-1">
        <div class="table-responsive-md">
            <table class="table datatable table-bordered table-hover table-striped" id="datatable" role="grid" aria-describedby="mobile-page-info">
                <thead>
                    <tr>
                        <th class="small text-muted">GRUPO</th>
                        <th class="small text-muted">ATIVO</th>
                        <th class="small text-muted"></th>
                    </tr>
                </thead>
                <tbody id="checkall-list">
                    <?php foreach ($groups as $e) : ?>
                        <tr>
                            <td>
                                <span class="d-block text-muted small"><?php echo $e->id; ?></span>
                            </td>
                            <td>
                                <span class="d-block text-muted small"><?php echo $e->nome_grupo_categoria; ?></span>
                            </td>
                            <td class="dropstart text-end">
                                <!-- options -->
                                <a class="btn btn-sm btn-light btn-ghost btn-icon text-muted rounded-circle" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                                    <span class="group-icon">
                                        <svg width="18px" height="18px" viewBox="0 0 16 16" xmlns="http://www.w3.org/2000/svg" fill="currentColor">
                                            <path fill-rule="evenodd" d="M9.5 13a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0zm0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0zm0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0z"></path>
                                        </svg>
                                        <svg xmlns="http://www.w3.org/2000/svg" width="18px" height="18px" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                            <line x1="18" y1="6" x2="6" y2="18"></line>
                                            <line x1="6" y1="6" x2="18" y2="18"></line>
                                        </svg>
                                    </span>
                                </a>
                                <ul class="dropdown-menu dropdown-menu-clean">
                                    <a class="dropdown-item" href="<?php echo base_url() . '/device/monitor/group/' . $e->id; ?>/devices">
                                        <em class="fi fi-smartphone-chat"></em>
                                        Devices ativos
                                    </a>
                                </ul>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<!-- /widgets -->
<?php $this->endsection(); ?>
<?php $this->section('scripts'); ?>
<script src="<?php echo base_url(); ?>/assets/js/vendor.datatables.js"></script>
<script>
    $(document).ready(function() {
        //
    });
</script>

<?php $this->endsection(); ?>