<?php $this->extend('layout/app'); ?>

<?php $this->section('header'); ?>
<title>Terminais</title>
<?php $this->endsection(); ?>
<?php $this->section('main'); ?>

<div class="section p-0">
    <div class="card-header p-4">
        <div class="row g-3">
            <div class="order-2 order-md-1 col">
                <div class="w-100">
                    <h2 class="h5 mb-0">Cadastro de Terminais</h2>
                </div>
            </div>
            <div class="order-1 order-md-2 col-md-auto">
                <a href="<?php echo base_url() . '/device/add'; ?>" class="w-100 btn btn-sm btn-primary">
                    <svg width="18px" height="18px" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <line x1="12" y1="5" x2="12" y2="19"></line>
                        <line x1="5" y1="12" x2="19" y2="12"></line>
                    </svg>
                    <span>Novo terminal</span>
                </a>
            </div>
        </div>
    </div>
    <div class="card-body pt-1">
        <div class="table-responsive-md">
            <div class="row align-items-start my-4">
                <div class="order-1 order-md-2 col-md-auto">
                    <label for="filter-event" class="form-label">Grupo de Acesso</label>
                    <select class="form-select form-select-sm filters" id="filter-group" name="group">
                        <option value="" selected>Todos</option>
                        <?php foreach ($groups as $e) : ?>
                            <option value="<?php echo $e->id; ?>"><?php echo $e->nome_grupo_categoria; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="order-1 order-md-2 col-md-auto">
                    <label for="filter-category" class="form-label">Tipo</label>
                    <select class="form-select form-select-sm filters" id="filter-model" name="model">
                        <option value="" selected>Todos</option>
                        <?php foreach ($types as $ca) : ?>
                            <option value="<?php echo $ca; ?>"><?php echo $ca; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="order-1 order-md-2 col-md-auto">
                    <label for="filter-status" class="form-label">Status</label>
                    <select class="form-select form-select-sm filters" id="filter-status" name="status">
                        <option value="" selected>Todos</option>
                        <option value="Y">Ativo</option>
                        <option value="N">Bloqueado</option>
                    </select>
                </div>
            </div>
            <table class="table datatable table-bordered table-hover table-striped" id="datatable" role="grid" aria-describedby="mobile-page-info">
                <thead>
                    <tr>
                        <th style="width:46px">
                            <div class="form-check">
                                ID
                            </div>
                        </th>
                        <th class="small text-muted">NOME</th>
                        <th class="small text-muted">TERMINAL ID</th>
                        <th class="small text-muted">IP(*)</th>
                        <th class="small text-muted">MODEL</th>
                        <th class="small text-muted">PIN</th>
                        <th class="small text-muted">GRUPO</th>
                        <th class="small text-muted">ATIVO</th>
                        <th class="small text-muted"></th>
                    </tr>
                </thead>
                <tbody id="checkall-list"></tbody>
            </table>
        </div>
    </div>
</div>
<!-- /widgets -->
<?php $this->endsection(); ?>
<?php $this->section('scripts'); ?>
<script src="<?php echo base_url(); ?>/assets/js/vendor.datatables.js"></script>
<script>
    $(document).ready(function() {
        $('.filters').change(function() {
            $('#datatable').DataTable().ajax.reload();
        });
        var table = $('#datatable').dataTable({
            processing: true,
            serverSide: true,
            pageLength: 10,
            searchDelay: 600,
            order: [
                [0, "desc"],
                [1, "asc"]
            ],
            ajax: {
                "url": "<?php echo base_url(); ?>/device/data",
                "data": function(d) {
                    var group = $('#filter-group').val();
                    var model = $('#filter-model').val();
                    var status = $('#filter-status').val();
                    return $.extend({}, d, {
                        status: status,
                        model: model,
                        group: group,
                    });
                }
            },
            loadingMessage: 'Carregando...',
            dom: '<"toolbar">frtip',
            class: 'pagination',
            columnDefs: [{
                responsivePriority: 1,
                targets: 0
            }],
            language: {
                emptyTable: "Nenhum registro destaqueizado.",
                info: "Exibindo _START_ até _END_ de _TOTAL_ registros",
                infoEmpty: "Exibindo 0 até 0 de 0 registros",
                infoFiltered: "(filtrados de _MAX_ no total)",
                infoPostFix: "",
                thousands: ",",
                lengthMenu: "Exibindo _MENU_ registros",
                loadingRecords: "Carregando...",
                processing: "Processando...",
                search: "Busca:",
                zeroRecords: "Nenhum registro destaqueizado.",
                paginate: {
                    first: "Primeiro",
                    last: "Ultimo",
                    next: "Prox.",
                    previous: "Ant."
                },
                aria: {
                    sortAscending: ": activate to sort column ascending",
                    sortDescending: ": activate to sort column descending"
                }
            }
        });
    });
</script>

<?php $this->endsection(); ?>