<?php $this->extend('layout/app'); ?>

<?php $this->section('header'); ?>
<title>Terminal</title>
<?php $this->endsection(); ?>
<?php $this->section('main'); ?>

<form class="form-validate" method="post" action="<?php echo base_url() . '/ihm'; ?>" id="form-device-ihm">
    <div class="row g-4">
        <!-- side -->
        <div class="">
            <div class="section">
                <div class="h5 card-header border-bottom-0 fw-bold">Catracas IHM</div>
                <div class="card-body">
                    <div class="row g-3">
                        <div class="col">
                            <div class="border border-secondary rounded-1 p-1">
                                <p class="fs-6 m-0">Configurações gerais</p>
                                <div class="input-group input-group-sm p-1">
                                    <select class="form-select form-select-sm filters" id="giro_entrada" name="giro_entrada">
                                        <?php foreach ($listaGiro as $giro) : ?>
                                            <option value="<?php echo $giro->key; ?>" <?php echo $giro->key == $param->giro_entrada ? "selected" : ""; ?>><?php echo $giro->value; ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                    <span class="input-group-text w-75" id="basic-addon1">Sentido do giro da entrada</span>
                                </div>
                                <div class="input-group input-group-sm p-1">
                                    <select class="form-select form-select-sm filters" id="bloq_braco_desc" name="bloq_braco_desc">
                                        <?php foreach ($listaBloqueiaBraco as $item) : ?>
                                            <option value="<?php echo $item->key; ?>" <?php echo $item->key == $param->bloq_braco_desc ? "selected" : ""; ?>><?php echo $item->value; ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                    <span class="input-group-text w-75" id="basic-addon1">Bloquear Braço quando inoperante.</span>
                                </div>
                                <div class="input-group input-group-sm p-1">
                                    <input type="number" min="0" max="60" class="form-control" id="temp_acesso" name="temp_acesso" value="<?php echo $param->temp_acesso; ?>">
                                    <span class="input-group-text w-75" id="basic-addon1">Tempo para efetuar acesso (sec)</span>
                                </div>
                                <div class="input-group input-group-sm p-1">
                                    <select class="form-select form-select-sm filters" id="qtd_dig" name="qtd_dig">
                                        <?php for ($lista = 4; $lista <= 25; $lista++) : ?>
                                            <option value="<?php echo $lista; ?>" <?php echo $lista == $param->qtd_dig ? "selected" : ""; ?>><?php echo $lista; ?></option>
                                        <?php endfor; ?>
                                    </select>
                                    <span class="input-group-text w-75" id="basic-addon1">Quantidade de Dígitos (max)</span>
                                </div>
                                <div class="input-group input-group-sm p-1">
                                    <input type="text" class="form-control" id="senha_quip" name="senha_quip" value="<?php echo $param->senha_quip; ?>">
                                    <span class="input-group-text w-75" id="basic-addon1">Senha de Equipamento</span>
                                </div>
                                <div class="input-group input-group-sm p-1">
                                    <input type="number" class="form-control" id="temp_resp_sw" name="temp_resp_sw" value="<?php echo $param->temp_resp_sw; ?>">
                                    <span class="input-group-text w-75" id="basic-addon1">Tempo de aguardo de resposta</span>
                                </div>
                                <div class="input-group input-group-sm p-1">
                                    <select class="form-select form-select-sm filters" id="libera_braco" name="libera_braco">
                                        <?php foreach ($listaLiberacaoBraco as $item) : ?>
                                            <option value="<?php echo $item->key; ?>" <?php echo $item->key == $param->libera_braco ? "selected" : ""; ?>><?php echo $item->value; ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                    <span class="input-group-text w-75" id="basic-addon1">Manter o braço liberado</span>
                                </div>
                                <div class="input-group input-group-sm p-1">
                                    <select class="form-select form-select-sm filters" id="contador_disp" name="contador_disp">
                                        <?php foreach ($listaDisplay as $item) : ?>
                                            <option value="<?php echo $item->key; ?>" <?php echo $item->key == $param->contador_disp ? "selected" : ""; ?>><?php echo $item->value; ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                    <span class="input-group-text w-75" id="basic-addon1">Contador no display</span>
                                </div>
                            </div>
                            <div class="border border-secondary rounded-1 p-1 mt-2">
                                <p class="fs-6 m-0">Barras</p>
                                <div class="input-group input-group-sm p-1">
                                    <div class="input-group-text">
                                        <input class="form-check-input" <?php echo $param->hab_barra1 == 1 ? "checked" : ""; ?> id="hab_barra1" name="hab_barra1" type="checkbox" value="1">
                                    </div>
                                    <span class="input-group-text w-75" id="basic-addon1">Habilitar barras 1</span>
                                </div>
                                <div class="input-group input-group-sm p-1">
                                    <select class="form-select form-select-sm filters" id="sentido_barra1" name="sentido_barra1">
                                        <?php foreach ($listaSentidoGiro as $item) : ?>
                                            <option value="<?php echo $item->key; ?>" <?php echo $item->key == $param->sentido_barra1 ? "selected" : ""; ?>><?php echo $item->value; ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                    <span class="input-group-text w-50" id="basic-addon1">Sentido do giro Barras 1</span>
                                </div>
                                <div class="input-group input-group-sm p-1">
                                    <div class="input-group-text">
                                        <input class="form-check-input" <?php echo $param->hab_barra2 == 1 ? "checked" : ""; ?> id="hab_barra2" name="hab_barra2" type="checkbox" value="1">
                                    </div>
                                    <span class="input-group-text w-75" id="basic-addon1">Habilitar barras 2</span>
                                </div>
                                <div class="input-group input-group-sm p-1">
                                    <select class="form-select form-select-sm filters" id="sentido_barra2" name="sentido_barra2">
                                        <?php foreach ($listaSentidoGiro as $item) : ?>
                                            <option value="<?php echo $item->key; ?>" <?php echo $item->key == $param->sentido_barra2 ? "selected" : ""; ?>><?php echo $item->value; ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                    <span class="input-group-text w-50" id="basic-addon1">Sentido do giro Barras 2</span>
                                </div>
                                <div class="input-group input-group-sm p-1">
                                    <select class="form-select form-select-sm filters" id="padrao_barcode" name="padrao_barcode">
                                        <?php foreach ($listaPadraoBarcode as $item) : ?>
                                            <option value="<?php echo $item->key; ?>" <?php echo $item->key == $param->padrao_barcode ? "selected" : ""; ?>><?php echo $item->value; ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                    <span class="input-group-text w-50" id="basic-addon1">Padrão do BarCode</span>
                                </div>
                            </div>
                        </div>
                        <div class="col">
                            <div class="border border-secondary rounded-1 p-1">
                                <p class="fs-6 m-0">Habilita teclado</p>
                                <div class="input-group input-group-sm p-1">
                                    <div class="input-group-text">
                                        <input class="form-check-input" <?php echo $param->hab_keyb == 1 ? "checked" : ""; ?> id="hab_keyb" name="hab_keyb" type="checkbox" value="1">
                                    </div>
                                    <span class="input-group-text w-75" id="basic-addon1">Habilitar Teclado</span>
                                </div>
                                <div class="input-group input-group-sm p-1">
                                    <select class="form-select form-select-sm filters" id="sentido_keyb" name="sentido_keyb">
                                        <?php foreach ($listaSentidoGiro as $item) : ?>
                                            <option value="<?php echo $item->key; ?>" <?php echo $item->key == $param->sentido_keyb ? "selected" : ""; ?>><?php echo $item->value; ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                    <span class="input-group-text w-50" id="basic-addon1">Sentido do giro Teclado</span>
                                </div>
                            </div>
                            <div class="border border-secondary rounded-1 p-1 mt-2">
                                <p class="fs-6 m-0">Habilita RFID 1</p>
                                <div class="input-group input-group-sm p-1">
                                    <div class="input-group-text">
                                        <input class="form-check-input" <?php echo $param->hab_rfid1 == 1 ? "checked" : ""; ?> id="hab_rfid1" name="hab_rfid1" type="checkbox" value="1">
                                    </div>
                                    <span class="input-group-text w-75" id="basic-addon1">Habilitar RFID 1</span>
                                </div>
                                <div class="input-group input-group-sm p-1">
                                    <select class="form-select form-select-sm filters" id="sentido_rfid1" name="sentido_rfid1">
                                        <?php foreach ($listaSentidoGiro as $item) : ?>
                                            <option value="<?php echo $item->key; ?>" <?php echo $item->key == $param->sentido_rfid1 ? "selected" : ""; ?>><?php echo $item->value; ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                    <span class="input-group-text w-50" id="basic-addon1">Sentido do giro RFID 1</span>
                                </div>
                                <div class="input-group input-group-sm p-1">
                                    <div class="input-group-text">
                                        <input class="form-check-input" <?php echo $param->hab_rfid2 == 1 ? "checked" : ""; ?> id="hab_rfid2" name="hab_rfid2" type="checkbox" value="1">
                                    </div>
                                    <span class="input-group-text w-75" id="basic-addon1">Habilitar RFID 2</span>
                                </div>
                                <div class="input-group input-group-sm p-1">
                                    <select class="form-select form-select-sm filters" id="sentido_rfid2" name="sentido_rfid2">
                                        <?php foreach ($listaSentidoGiro as $item) : ?>
                                            <option value="<?php echo $item->key; ?>" <?php echo $item->key == $param->sentido_rfid2 ? "selected" : ""; ?>><?php echo $item->value; ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                    <span class="input-group-text w-50" id="basic-addon1">Sentido do giro RFID 2</span>
                                </div>
                            </div>
                            <div class="border border-secondary rounded-1 p-1 mt-2">
                                <p class="fs-6 m-0">Mensagens</p>
                                <div class="input-group input-group-sm p-1">
                                    <input type="text" class="form-control" id="msg01" name="msg01" value="<?php echo $param->msg01; ?>">
                                    <span class="input-group-text w-30" id="basic-addon1">Inválido</span>
                                </div>
                                <div class="input-group input-group-sm p-1">
                                    <input type="text" class="form-control" id="msg02" name="msg02" value="<?php echo $param->msg02; ?>">
                                    <span class="input-group-text w-30" id="basic-addon1">Inativo</span>
                                </div>
                                <div class="input-group input-group-sm p-1">
                                    <input type="text" class="form-control" id="msg03" name="msg03" value="<?php echo $param->msg03; ?>">
                                    <span class="input-group-text w-30" id="basic-addon1">Cancelado</span>
                                </div>
                                <div class="input-group input-group-sm p-1">
                                    <input type="text" class="form-control" id="msg04" name="msg04" value="<?php echo $param->msg04; ?>">
                                    <span class="input-group-text w-30" id="basic-addon1">Bloqueado</span>
                                </div>
                                <div class="input-group input-group-sm p-1">
                                    <input type="text" class="form-control" id="msg05" name="msg05" value="<?php echo $param->msg05; ?>">
                                    <span class="input-group-text w-30" id="basic-addon1">Sem permissão</span>
                                </div>
                                <div class="input-group input-group-sm p-1">
                                    <input type="text" class="form-control" id="msg06" name="msg06" value="<?php echo $param->msg06; ?>">
                                    <span class="input-group-text w-30" id="basic-addon1">Liberado</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-footer border-light">
                    <button type="submit" class="btn btn-primary">
                        <svg width="18px" height="18px" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <polyline points="20 6 9 17 4 12"></polyline>
                        </svg>
                        <span>Salvar</span>
                    </button>
                </div>
            </div>
        </div>
    </div>
</form>
<?php $this->endsection(); ?>
<?php $this->section('scripts'); ?>
<script>

</script>
<?php $this->endsection(); ?>