<?php $this->extend('layout/app'); ?>

<?php $this->section('header'); ?>
<title>Terminal</title>
<?php $this->endsection(); ?>
<?php $this->section('main'); ?>

<form class="form-validate" method="post" action="<?php echo base_url() . '/device' . (!empty($device->id) ? "/{$device->id}" : ""); ?>" id="form-device">
    <div class="row g-4">
        <!-- side -->
        <div class="">
            <div class="section">
                <div class="h5 card-header border-bottom-0 fw-bold">Terminal</div>
                <div class="card-body">
                    <div class="row g-3 mb-3">
                        <div class="col">
                            <div class="form-floating">
                                <input required type="text" class="form-control" id="terminal_nome" name="terminal_nome" placeholder="Nome do terminal" value="<?php echo $device->terminal_nome; ?>">
                                <label for="terminal_nome">Nome</label>
                            </div>
                        </div>
                        <div class="col">
                            <div class="form-floating">
                                <select class="form-select form-select-sm filters" id="terminal_model" name="terminal_model">
                                    <?php foreach ($types as $type) : ?>
                                        <option value="<?php echo $type; ?>" <?php echo $type == $device->terminal_model ? "selected" : ""; ?>><?php echo $type; ?></option>
                                    <?php endforeach; ?>
                                </select>
                                <label for="terminal_model" class="form-label">TIPO</label>
                            </div>
                        </div>
                        <div class="col" id="d-id">
                            <div class="form-floating">
                                <input type="text" class="form-control" id="terminal_id" name="terminal_id" placeholder="TERMINAL ID" value="<?php echo $device->terminal_id; ?>">
                                <label for="terminal_pin">TERMINAL</label>
                            </div>
                        </div>
                        <div class="col" id="d-pin">
                            <div class="form-floating">
                                <input type="text" class="form-control" id="terminal_pin" name="terminal_pin" placeholder="PIN de acesso" value="<?php echo $device->terminal_pin; ?>">
                                <label for="terminal_pin">PIN</label>
                            </div>
                        </div>
                        <div class="col" id="d-ip">
                            <div class="form-floating">
                                <input type="text" class="form-control" id="terminal_ip" name="terminal_ip" placeholder="IP do equipamento" value="<?php echo $device->terminal_ip; ?>">
                                <label for="terminal_pin">IP</label>
                            </div>
                        </div>
                    </div>
                    <div class="row g-3 mb-3">
                        <div class="col">
                            <div class="form-floating">
                                <select class="form-select form-select-sm filters" id="grupo_categoria_id" name="grupo_categoria_id">
                                    <?php foreach ($groups as $group) : ?>
                                        <option value="<?php echo $group->id; ?>" <?php echo $group->id == $device->grupo_categoria_id ? "selected" : ""; ?>><?php echo $group->nome_grupo_categoria; ?></option>
                                    <?php endforeach; ?>
                                </select>
                                <label for="grupo_categoria_id" class="form-label">GRUPO DE ACESSO</label>
                            </div>
                        </div>
                        <div class="col">
                            <label class="d-flex align-items-center mb-3">
                                <input class="d-none-cloaked" type="checkbox" name="ativo" id="ativo" value="1" <?php echo $device->ativo == '1' ? 'checked=""' : ''; ?>>
                                <em class="switch-icon switch-icon-primary switch-icon-xs"></em>
                                <span class="px-3 user-select-none">Ativo</span>
                            </label>
                        </div>
                    </div>
                </div>
                <div class="card-footer border-light">
                    <a href="<?php echo base_url(); ?>/device" class="btn btn-secondary">
                        <em class="fi fi-arrow-left"></em>
                        <span>Voltar</span>
                    </a>
                    <button type="submit" class="btn btn-primary">
                        <svg width="18px" height="18px" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <polyline points="20 6 9 17 4 12"></polyline>
                        </svg>
                        <span><?php echo $device->id ? 'Salvar' : 'Criar Terminal'; ?></span>
                    </button>
                    <?php if ($device->id) { ?>
                        <button type="button" id="btn-remove" class="btn btn-danger">
                            <svg width="18px" height="18px" xmlns="http://www.w3.org/2000/svg" fill="currentColor" class="bi bi-x-circle" viewBox="0 0 16 16">
                                <path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14zm0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16z"></path>
                                <path d="M4.646 4.646a.5.5 0 0 1 .708 0L8 7.293l2.646-2.647a.5.5 0 0 1 .708.708L8.707 8l2.647 2.646a.5.5 0 0 1-.708.708L8 8.707l-2.646 2.647a.5.5 0 0 1-.708-.708L7.293 8 4.646 5.354a.5.5 0 0 1 0-.708z"></path>
                            </svg>
                            <span>Excluir Device</span>
                        </button>
                    <?php  } ?>
                </div>
            </div>
        </div>
    </div>
</form>
<!-- Modal -->
<div class="modal fade" id="modalRemove" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabelSm" aria-hidden="true">
    <div class="modal-dialog modal-sm" role="document">
        <div class="modal-content">

            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabelSm">Remover Device</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>

            <div class="modal-body">
                Confirma a exclusão deste device? confirmando, esta operação não poderá ser desfeita!
            </div>

            <div class="modal-footer">
                <button type="button" id="act-remove" class="btn btn-sm btn-warning">
                    <i class="fi fi-check"></i>
                    Confirmar
                </button>
                <button type="button" class="btn btn-sm btn-secondary" data-bs-dismiss="modal">
                    <i class="fi fi-close"></i>
                    Fechar
                </button>
            </div>

        </div>
    </div>
</div>
<?php $this->endsection(); ?>
<?php $this->section('scripts'); ?>
<script>
    $(document).ready(function() {
        displayChange()
        $("#terminal_model").change(() => displayChange())
        $("#btn-remove").click(() => {
            $('#modalRemove').modal('show')
        })
        <?php if ($device->id) { ?>
        $("#act-remove").click(() => {
            window.location.href= '<?php echo base_url(); ?>/device/delete/<?php echo $device->id; ?>'
        })
        <?php } ?>

    })

    function displayChange() {
        const model = $("#terminal_model option:selected").text()
        console.log('tipo...', model)
        if (model === 'CATRACA') {
            $("#d-pin").hide()
            $("#d-ip").show()
            $("#d-id").show()
        } else {
            $("#d-pin").show()
            $("#d-ip").hide()
            $("#d-id").hide()
        }
    }
</script>
<?php $this->endsection(); ?>