<?php $this->extend('layout/app'); ?>

<?php $this->section('header'); ?>
<title>Dashboard</title>

<?php $this->endsection(); ?>
<?php $this->section('main'); ?>

<div class="section rounded mb-3">

    <div class="py-2 px-3 mb-3 mt-1">
        <div class="row g-3">

            <!-- review filter -->
            <div class="order-2 order-md-1 col">
                <div class="w-100">
                    <h2 class="h5 mb-0">Cadastros &amp; Acessos</h2>
                    <small class="small text-muted"><?php echo date('d/m/Y H:i'); ?></small>
                </div>
            </div>

            <!-- options -->
            <div class="order-1 order-md-2 col-md-auto">
                <select class="form-control form-select" id="evento">
                    <?php foreach ($eventos as $e) : ?>
                        <option value="<?php echo $e->id; ?>"><?php echo $e->evento; ?></option>
                    <?php endforeach; ?>
                </select>
            </div>

        </div>

    </div>

</div>
<div class="section rounded mb-3">
    <div class="d-flex align-items-center justify-content-between border-bottom pb-2 my-2">
        <div class="w-100">
            <h6 class="h5 mb-0">Entrada de Ingressos</h6>
            <div id="chart-tickets">
            </div>
        </div>
    </div>
    <div class="d-flex align-items-center justify-content-between border-bottom pb-2 my-2">
        <div class="w-100">
            <h6 class="h5 mb-0">Reentrada Credenciados</h6>
            <div id="chart-reentry">
            </div>
        </div>
    </div>
    <div class="d-flex align-items-center justify-content-between border-bottom pb-2 my-2">
        <div class="w-100">
            <h6 class="h5 mb-0">Reentrada Colaboradores</h6>
            <div id="chart-reentrycolab">
            </div>
        </div>
    </div>
</div>



<!-- /Primary -->


<!-- widgets -->
<div class="row g-3 mb-3">

    <div class="col-12 col-md-6 col-xl-4">

        <!-- small graph widget -->
        <div class="bg-white shadow-md text-dark p-5 rounded text-center">

            <!-- icon -->
            <span class="d-inline-flex align-items-center justify-content-center bg-light text-gray-900 rounded-circle" style="width: 100px;height:100px">
                <svg xmlns="http://www.w3.org/2000/svg" width="64" height="64" fill="currentColor" class="bi bi-ticket-perforated-fill" viewBox="0 0 16 16">
                    <path d="M0 4.5A1.5 1.5 0 0 1 1.5 3h13A1.5 1.5 0 0 1 16 4.5V6a.5.5 0 0 1-.5.5 1.5 1.5 0 0 0 0 3 .5.5 0 0 1 .5.5v1.5a1.5 1.5 0 0 1-1.5 1.5h-13A1.5 1.5 0 0 1 0 11.5V10a.5.5 0 0 1 .5-.5 1.5 1.5 0 1 0 0-3A.5.5 0 0 1 0 6V4.5Zm4-1v1h1v-1H4Zm1 3v-1H4v1h1Zm7 0v-1h-1v1h1Zm-1-2h1v-1h-1v1Zm-6 3H4v1h1v-1Zm7 1v-1h-1v1h1Zm-7 1H4v1h1v-1Zm7 1v-1h-1v1h1Zm-8 1v1h1v-1H4Zm7 1h1v-1h-1v1Z" />
                </svg>
            </span>

            <ul class="list-group">
                <li class="list-group-item">
                    <h3 class="">Ingressos</h3>
                </li>
                <li class="list-group-item">
                    Lidos: <span id="lidos-ticket"></span>
                </li>
                <li class="list-group-item">
                    Bloqueados: <span id="block-ticket"></span>
                </li>
                <li class="list-group-item">
                    Cadastros: <span id="reserve-ticket"></span>
                </li>
            </ul>

        </div>
        <!-- /small graph widget -->

    </div>

    <div class="col-12 col-md-6 col-xl-4">

        <!-- small graph widget -->
        <div class="bg-white shadow-md text-dark p-5 rounded text-center">

            <!-- icon -->
            <span class="d-inline-flex align-items-center justify-content-center bg-light text-gray-900 rounded-circle" style="width: 100px;height:100px">
                <svg xmlns="http://www.w3.org/2000/svg" width="64" height="64" fill="currentColor" class="bi bi-person-vcard-fill" viewBox="0 0 16 16">
                    <path d="M0 4a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2V4Zm9 1.5a.5.5 0 0 0 .5.5h4a.5.5 0 0 0 0-1h-4a.5.5 0 0 0-.5.5ZM9 8a.5.5 0 0 0 .5.5h4a.5.5 0 0 0 0-1h-4A.5.5 0 0 0 9 8Zm1 2.5a.5.5 0 0 0 .5.5h3a.5.5 0 0 0 0-1h-3a.5.5 0 0 0-.5.5Zm-1 2C9 10.567 7.21 9 5 9c-2.086 0-3.8 1.398-3.984 3.181A1 1 0 0 0 2 13h6.96c.026-.163.04-.33.04-.5ZM7 6a2 2 0 1 0-4 0 2 2 0 0 0 4 0Z" />
                </svg>
            </span>


            <ul class="list-group">
                <li class="list-group-item">
                    <h3 class="">Credenciados</h3>
                </li>
                <li class="list-group-item">
                    Lidos: <span id="lidos-reentry"></span>
                </li>
                <li class="list-group-item">
                    Bloqueados: <span id="block-reentry"></span>
                </li>
                <li class="list-group-item">
                    Cadastros: <span id="reserve-reentry"></span>
                </li>
            </ul>

        </div>
        <!-- /small graph widget -->

    </div>
    <div class="col-12 col-md-6 col-xl-4">

        <!-- small graph widget -->
        <div class="bg-white shadow-md text-dark p-5 rounded text-center">

            <!-- icon -->
            <span class="d-inline-flex align-items-center justify-content-center bg-light text-gray-900 rounded-circle" style="width: 100px;height:100px">
                <svg width="64px" height="64px" xmlns="http://www.w3.org/2000/svg" fill="currentColor" class="bi bi-clock-fill" viewBox="0 0 16 16">
                    <path d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0zM8 3.5a.5.5 0 0 0-1 0V9a.5.5 0 0 0 .252.434l3.5 2a.5.5 0 0 0 .496-.868L8 8.71V3.5z"></path>
                </svg>
            </span>


            <ul class="list-group">
                <li class="list-group-item">
                    <h3 class="">Colaboradores</h3>
                </li>
                <li class="list-group-item">
                    Lidos: <span id="lidos-colab"></span>
                </li>
                <li class="list-group-item">
                    Bloqueados: <span id="block-colab"></span>
                </li>
                <li class="list-group-item">
                    Cadastros: <span id="reserve-colab"></span>
                </li>
            </ul>

        </div>
        <!-- /small graph widget -->

    </div>

</div>
<!-- /widgets -->


<!-- widgets -->
<div class="row g-3">

    <!-- tasks -->
    <div class="col-12 col-xl-12">
        <div class="portlet">
            <div class="portlet-header">
                <span class="d-block text-muted text-truncate fw-medium">
                    Tasks
                </span>
            </div>
            <div id="tabUserListContent" class="portlet-body max-h-500 tab-content">
                <div class="h-100 tab-pane show active" id="usertab_1">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th scope="col">Tipo</th>
                                <th scope="col">Categoria</th>
                                <th scope="col">Registros</th>
                                <th scope="col">Ativos</th>
                                <!-- <th scope="col">Inativos</th> -->
                                <th scope="col">Leituras Unicas</th>
                                <th scope="col">Leituras Totais</th>
                                <th scope="col">Entrega Totais</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($dataSynth as $ds) : ?>
                                <tr>
                                    <th scope="row"><?php echo $ds->tipo; ?></th>
                                    <td><?php echo $ds->categoria; ?></td>
                                    <td><span id='tickets_<?php echo $ds->id; ?>'></span></td>
                                    <td><span id='tickets_ativos_<?php echo $ds->id; ?>'></span></td>
                                    <!-- <td><span id='tickets_bloqueados_<?php echo $ds->id; ?>'></span></td> -->
                                    <td class="text-center"><span id='tickets_lido_unico_<?php echo $ds->id; ?>'></span></td>
                                    <td class="text-center"><span id='tickets_lido_<?php echo $ds->id; ?>'></span></td>
                                    <td class="text-center"><span id='entrega_lido_<?php echo $ds->id; ?>'></span></td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <!-- /tasks -->

    <!-- orders -->

</div>
<?php $this->endsection(); ?>
<?php $this->section('scripts'); ?>
<script src="<?php echo base_url(); ?>/assets/js/apexcharts.js"></script>
<script>
    $(document).ready(function() {
        const options = {
            chart: {
                type: 'bar'
            },
            series: []
        }
        const chartTicket = new ApexCharts(document.querySelector("#chart-tickets"), options);
        const chartReentry = new ApexCharts(document.querySelector("#chart-reentry"), options);
        const chartReentrycolab = new ApexCharts(document.querySelector("#chart-reentrycolab"), options);
        chartTicket.render();
        chartReentry.render();
        chartReentrycolab.render();

        setInterval(() => {
            getDataChart(1)
            getDataChart(2)
        }, 10000)

        setInterval(() => {
            getTotais()
        }, 3000)
        setInterval(() => {
            getResume()
        }, 5000)

        const getDataChart = (id) => {
        
            let evento = $("#evento").val();
            $.get('<?php echo base_url(); ?>/dashboard/data/' + id+'/'+evento, (response) => {

                if (response != null) {
                    chartTicket.updateSeries([{
                        data: response.ticket
                    }])
                    chartReentry.updateSeries([{
                        data: response.reentry
                    }])
                    chartReentrycolab.updateSeries([{
                        data: response.reentryColab
                    }])
                }
            }).done(() => {
                //
            })
        }
        const getTotais = () => {
            let evento = $("#evento").val();
            $.get('<?php echo base_url(); ?>/dashboard/data/quantity/' + evento, (response) => {

                if (response != null) {
                    $("#lidos-ticket").html(response.tickets.lidos)
                    $("#block-ticket").html(response.tickets.bloqueados)
                    $("#reserve-ticket").html(response.tickets.qtd)

                    $("#lidos-reentry").html(response.reentry.lidos)
                    $("#block-reentry").html(response.reentry.bloqueados)
                    $("#reserve-reentry").html(response.reentry.qtd)

                    $("#lidos-colab").html(response.colab.lidos)
                    $("#block-colab").html(response.colab.bloqueados)
                    $("#reserve-colab").html(response.colab.qtd)
                }
            }).done(() => {
                //
            })
        }
        const getResume = () => {
            let evento = $("#evento").val();
            $.get('<?php echo base_url(); ?>/dashboard/data/resume/' + evento, (response) => {

                if (response) {
                    //console.log(response)
                    response.forEach(el => {
                        if ($('#tickets_' + el.id).length) {
                            $('#tickets_' + el.id).html(el.tickets)
                            $('#tickets_ativos_' + el.id).html(el.tickets_ativos)
                            $('#tickets_bloqueados_' + el.id).html(el.tickets_bloqueados)
                            $('#tickets_lido_unico_' + el.id).html(el.tickets_lido_unico)
                            $('#tickets_lido_' + el.id).html(el.tickets_lido)
                            $('#entrega_lido_' + el.id).html(el.entrega_lido)
                        }
                    })
                }
            }).done(() => {
                //
            })
        }
    })
</script>
<!-- /widgets -->
<?php $this->endsection(); ?>