<?php $this->extend('layout/app'); ?>

<?php $this->section('header'); ?>
<title>Departamentos</title>
<?php $this->endsection(); ?>
<?php $this->section('main'); ?>

<main>
    <div class="container-fluid px-4">
        <h1 class="mt-4">Dashboard</h1>
        <ol class="breadcrumb mb-4">
            <li class="breadcrumb-item active">Entradas</li>
        </ol>
        <div class="card mb-4">
            <div class="card-header">
                <i class="fas fa-table me-1"></i>
                Acessos por ticket 
            </div>
            <div class="card-body">
                <table id="datatablesSimple" class="table table-striped">
                    <thead>
                        <tr>
                            <th>Cod</th>
                            <th>Nome</th>
                            <th>Categoria</th>
                            <th>Acessos</th>
                            <th>Primeiro</th>
                            <th>Ultimo</th>
                        </tr>
                    </thead>
                    
                    <tbody>
                        <?php foreach($getAcessosGeral as $l) { ?>
                        <tr>
                            <td><?php echo $l->cod; ?></td>
                            <td><?php echo $l->name; ?></td>
                            <td><?php echo $l->category_name; ?></td>
                            <td><?php echo $l->ticket_register; ?></td>
                            <td><?php echo date('d/m/Y H:i:s',strtotime($l->min)); ?></td>
                            <td><?php echo date('d/m/Y H:i:s',strtotime($l->max)); ?></td>
                        </tr>
                        <?php  } ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</main>
<?php $this->endsection(); ?>