<?php $this->extend('layout/app'); ?>

<?php $this->section('header'); ?>
<title>Importar de Ticket</title>
<?php $this->endsection(); ?>
<?php $this->section('main'); ?>

<?php
$attributes = ['class' => 'form-validate', 'id' => 'form-import'];
echo  form_open_multipart('manage/importsympla', $attributes); ?>
<div class="row g-4">
    <!-- side -->
    <div class="">
        <div class="section">
            <div class="h5 card-header border-bottom-0 fw-bold">Informe as categorias</div>
            <!-- item list -->
            <div class="table-responsive-md">

                <table class="table table-align-middle table-sm table-striped" role="grid" aria-describedby="mobile-page-info">
                    <thead>
                        <tr>
                            <th style="width:46px">
                                <div class="form-check">
                                    ID
                                </div>
                            </th>
                            <th class="small text-muted">CATEGORIA SYMPLA</th>
                            <th class="small text-muted">CATEGORIA</th>
                        </tr>
                    </thead>
                    <tbody id="checkall-list">
                        <!-- item -->
                        <?php foreach ($importCategory as $k => $ic) : ?>
                            <tr importcategoryid="<?php echo $ic->id; ?>">
                                <th>
                                    <span class="d-block text-muted small"><?php echo $ic->id; ?></span>
                                </th>
                                <td>
                                    <span class="d-block text-muted small"><?php echo $ic->import_name; ?></span>
                                </td>
                                <td>
                                    <span class="d-block text-muted small">
                                        <select class="form-select category form-select-sm filters" require id="filter-event" name="categories[]" data-importcategoryid="<?php echo $ic->id; ?>">
                                            <option value="">Selecione</option>
                                            <?php foreach ($categories as $e) : ?>
                                                <option <?php echo $ic->category_id == $e->id ? 'selected' : ''; ?> value="<?php echo $e->id; ?>"><?php echo $e->categoria; ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                    </span>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
            <!-- pagination, selected items -->
            <button type="button" class="btn btn-sm btn-primary" id="proccess">Continuar importação</button>
        </div>
    </div>
    <!-- Modal -->
    <div class="modal fade" id="finishModal" tabindex="-1" role="dialog" aria-labelledby="finishModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">

                <div class="modal-header">
                    <h5 class="modal-title" id="finishModalLabel">Relatório de importação</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <div class="modal-body">
                    <div class="row" >
                        <div class="col">Total de Tickets</div>
                        <div class="col"><span id="tickets"></span></div>
                    </div>
                    <div class="row" >
                        <div class="col">Tickets novos</div>
                        <div class="col"><span id="inserted"></span></div>
                    </div>
                    <div class="row" >
                        <div class="col">Tickets Atualizados</div>
                        <div class="col"><span id="updated"></span></div>
                    </div>
                    <div class="row" >
                        <div class="col">Tickets Registrados</div>
                        <div class="col"><span id="access"></span></div>
                    </div>
                </div>

                <div class="modal-footer">
                    <button type="button" id="goback" class="btn btn-secondary" data-bs-dismiss="modal">
                        <i class="fi fi-close"></i>
                        Fechar
                    </button>
                </div>

            </div>
        </div>
    </div>
</div>
<?php echo form_close(); ?>
<?php $this->endsection(); ?>
<?php $this->section('scripts'); ?>
<script>

    const finishModal = new bootstrap.Modal(document.getElementById('finishModal'), {
            keyboard: false
    });

    $(document).ready(function() {
        $("#proccess").click(() => processarCategorias())
    })

    function processarCategorias() {
        espera(true)
        const ca = $("select.category")
        let dados = []
        let status = true
        let qtdErros = 0
        ca.each((idx, el) => {
            var category = el.options[el.selectedIndex].value
            var importCategoryId = el.getAttribute('data-importcategoryid')
            console.log({
                category,
                importCategoryId
            })
            if (category == '') {
                qtdErros++
                // el.parentNode.classList.add('bg-primary')
                $("tr[importcategoryid='" + importCategoryId + "']").addClass('bg-primary')
                status = false
            }
            if (status)
                dados.push({
                    category,
                    importCategoryId
                })
        })
        if (qtdErros > 0) {
            cl.sn(`Faltam selecionar ${qtdErros} categorias`, 'danger')
            espera(false)
        } else {
            processaImportacao(dados)
        }
    }

    function processaImportacao(categories) {
        const dados = JSON.stringify({
            data: categories
        });
        $.ajax({
            type: 'POST',
            url: '<?php echo base_url(); ?>/manage/processasympla/<?php echo $import->id; ?>',
            data: dados,
            success: function(response) {
                finish(response)
            },
            complete: function(status) {
                console.log('status', status.status)
                if(status.status !== 200) {
                    espera(false)
                }
                
            },
            contentType: "application/json",
            dataType: 'json'
        })
    }

    function finish(data) {
        $("#proccess").html(`Finalizado!`)
        $("#proccess").removeClass('btn-primary')
        $("#proccess").prop("disabled", true);
        $("#proccess").addClass('btn-secondary')
        console.log('data:', data)
        $("#tickets").html(data.tickets)
        $("#inserted").html(data.inserted)
        $("#updated").html(data.updated)
        $("#access").html(data.access)
        finishModal.show();

    }

    function espera(sts) {
        if (sts) {
            $("#proccess").html(`<i class="fi fi-cog fi-spin"></i>Aguarde`)
            $("#proccess").removeClass('btn-primary')
            $("#proccess").prop("disabled", true);
            $("#proccess").addClass('btn-secondary')
        } else {
            $("#proccess").html(`Continuar importação`)
            $("#proccess").addClass('btn-primary')
            $("#proccess").prop("disabled", false);
            $("#proccess").removeClass('btn-secondary')
        }
    }
</script>
<?php $this->endsection(); ?>