<?php $this->extend('layout/app'); ?>

<?php $this->section('header'); ?>
<title>Categorias</title>
<?php $this->endsection(); ?>
<?php $this->section('main'); ?>

<!-- user list -->
<div class="section p-0">
    <div class="card-header p-4">

        <div class="row g-3">

            <!-- review filter -->
            <div class="order-2 order-md-1 col">
                <div class="w-100">
                    <h2 class="h5 mb-0">Cadastro de Categorias</h2>
                </div>
            </div>

            <!-- options -->
            <div class="order-1 order-md-2 col-md-auto">
                <a href="<?php echo base_url() . '/category/add'; ?>" class="w-100 btn btn-sm btn-primary">
                    <svg width="18px" height="18px" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <line x1="12" y1="5" x2="12" y2="19"></line>
                        <line x1="5" y1="12" x2="19" y2="12"></line>
                    </svg>
                    <span>Nova categoria</span>
                </a>
            </div>

        </div>

    </div>

    <div class="card-body pt-1">

        <!-- item list -->
        <div class="table-responsive-md">

            <table class="table table-align-middle" role="grid" aria-describedby="mobile-page-info">
                <thead>
                    <tr>
                        <th style="width:46px">
                            <div class="form-check">
                                ID
                            </div>
                        </th>
                        <th class="small text-muted">CATEGORIA</th>
                        <th class="small text-muted">TIPO</th>
                        <th class="small text-muted">MULTIPLO ACESSO</th>
                        <th class="small text-muted">CADASTROS</th>
                        <th class="small text-muted">
                            <!-- options -->
                        </th>
                    </tr>
                </thead>
                <tbody id="checkall-list">

                    <!-- item -->
                    <?php foreach ($categories as $k => $category) : ?>
                        <tr>
                            <th>
                                <span class="d-block text-muted small"><?php echo $category->id; ?></span>
                            </th>
                            <td>
                                <!-- user -->
                                <div class="d-flex align-items-center">
                                    <div class="avatar avatar-sm rounded-circle" style="background-image:url(../html_frontend/demo.files/images/avatar/jessica_barden.jpg)"></div>
                                    <div class="ms-3">
                                        <a href="<?php echo base_url() . '/category/' . $category->id;?>" class="link-normal fw-medium"><?php echo $category->categoria; ?></a>
                                    </div>
                                </div>
                            </td>
                            <td>
                                <span class="d-flex align-items-center"><?php echo $category->tipo; ?></span>
                            </td>
                            <td>
                                <span class="d-flex align-items-center"><i class="fi <?php echo $category->idr_multiplo == '1'?'fi-check':'fi-close';?>"></i></span>
                            </td>
                            <td>
                                <span class="d-flex align-items-center"><?php echo $category->tickets; ?></span>
                            </td>
                            
                            <td class="dropstart text-end">
                                <!-- options -->
                                <a class="btn btn-sm btn-light btn-ghost btn-icon text-muted rounded-circle" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                                    <span class="group-icon">
                                        <svg width="18px" height="18px" viewBox="0 0 16 16" xmlns="http://www.w3.org/2000/svg" fill="currentColor">
                                            <path fill-rule="evenodd" d="M9.5 13a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0zm0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0zm0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0z"></path>
                                        </svg>
                                        <svg xmlns="http://www.w3.org/2000/svg" width="18px" height="18px" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                            <line x1="18" y1="6" x2="6" y2="18"></line>
                                            <line x1="6" y1="6" x2="18" y2="18"></line>
                                        </svg>
                                    </span>
                                </a>
                                <ul class="dropdown-menu dropdown-menu-clean">
                                    <li class="small px-3 py-2 text-muted">Opções</li>
                                    <li>
                                        <a class="dropdown-item" href="<?php echo base_url() . '/category/' . $category->id;?>">
                                            <svg class="text-muted" width="18px" height="18px" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                                <polyline points="20 6 9 17 4 12"></polyline>
                                            </svg>
                                            <span>Editar</span>
                                        </a>
                                    </li>
                                </ul>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<!-- /widgets -->
<?php $this->endsection(); ?>