<?php $this->extend('layout/monitor'); ?>
<?php $this->section('header'); ?>
<title>Controle de acesso</title>

<?php $this->endsection(); ?>
<?php $this->section('main'); ?>
    <header>
        <div class="offcanvas offcanvas-end  bg-dark shadow-sm" tabindex="-1" id="offcanvasRight" aria-labelledby="offcanvasRightLabel">
            <div class="offcanvas-header">
                <h5 id="offcanvasRightLabel">Configurações</h5>
                <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas"
                    aria-label="Close"></button>
            </div>
            <div class="offcanvas-body">
                <div class="row g-3">
                    <div class="col-12">
                        <label for="email" class="form-label">PIN</label>
                        <input type="email" class="form-control" id="pin" placeholder="Identificação do leitor">
                    </div>
                    <div class="col-12">
                        <button class="w-100 btn btn-primary btn-lg" type="button" id="btn-save">Salvar</button>
                    </div>
                </div>
            </div>
        </div>
        <div class="navbar navbar-dark bg-dark shadow-sm">
            <div class="container">
                <a href="#" class="navbar-brand d-flex align-items-center">
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="none" stroke="currentColor"
                        stroke-linecap="round" stroke-linejoin="round" stroke-width="2" aria-hidden="true" class="me-2"
                        viewBox="0 0 24 24">
                        <path d="M23 19a2 2 0 0 1-2 2H3a2 2 0 0 1-2-2V8a2 2 0 0 1 2-2h4l2-3h6l2 3h4a2 2 0 0 1 2 2z" />
                        <circle cx="12" cy="13" r="4" />
                    </svg>
                    <strong>Controle de acesso</strong>
                </a>
                <button class="navbar-toggler" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasRight"
                    aria-controls="offcanvasRight">
                    <span class="navbar-toggler-icon"></span>
                </button>
            </div>
        </div>
    </header>

    <div id="main">
        <div class="row">
            <div class="col-md-6">
                <div class="p-4 text-secondary bg-dark">
                    <input type="text" class="form-control form-control-lg btn-success" id="card" />
                </div>
                <div class="form-control form-control-sm text-center text-white" id="data_1">****</div>
                <div class="form-control form-control-sm text-center" id="data_2">****</div>
                <div class="form-control form-control-sm text-center" id="data_3">****</div>
            </div>
            <div class="col-md-6">
                <div class="p-2">
                    <img class="img img-responsive" style="width: 100%" id="foto"
                        src=""
                        alt="" />
                </div>
            </div>
        </div>
    </div>
    <footer id="footer" class=" fixed-bottom text-white bg-danger">
        <div class="text-center" id="connect-status"></div>
    </footer>
    <?php $this->endsection(); ?>
    <?php $this->section('scripts'); ?>
    <script>
        const acesso = {
            status: false,
            setor: '',
            terminal_nome: null,
            terminal_id: null,
            uri :'<?php echo base_url(); ?>',
            config: {
                pin: ''
            },
            acao: [
                { key: 'PS', value: 'PASSAGEM LIBERADA' },
                { key: 'CI', value: 'TICKET INVÁLIDO' },
                { key: 'CB', value: 'TICKET BLOQUEADO' },
                { key: 'CR', value: 'TICKET REGISTRADO' },
                { key: 'CE', value: 'EVENTO EXPIRADO' },
                { key: 'CN', value: '..FALHA CONEXÃO..' },
                { key: 'CS', value: '..FALHA SOCKET..' },
                { key: 'EG', value: 'AGUARDANDO GIRO' },
                { key: 'EX', value: 'AGUARDANDO GIRO' }
            ],
            load: () => {
                const obj = acesso.storage.load('settings')
                if (obj != null) {
                    acesso.config.pin = obj.pin
                }
                $('#pin').val(acesso.config.pin)
            },
            save: () => {
                acesso.storage.save('settings', acesso.config)
                acesso.load()
            },
            init: () => {
                acesso.load()
                $("#btn-save").click(()=> {
                    acesso.config.pin = $('#pin').val()
                    acesso.save()
                    acesso.sendLogin()
                })
                $('#card').keyup(function (e) {
                    if (e.keyCode == 13) {
                        let card = $(this).val()
                        acesso.validate(card)
                        $(this).select()
                        //event.preventDefault();
                    }
                });
                setInterval(() => {
                    if (!acesso.status) {
                        $('#connect-status').html('... Desconectado ... Selecione o dispositivo (PIN) ...')
                        $('footer').removeClass('bg-success')
                        $('footer').addClass('bg-danger')
                        acesso.sendLogin()
                    } else {
                        $('#connect-status').html(`GRUPO: <strong>${acesso.setor}</strong> ---- TERMINAL: <strong>${acesso.terminal_nome}</strong>`)
                        $('footer').removeClass('bg-danger')
                        $('footer').addClass('bg-success')
                    }
                }, 400);
            },
            sendLogin: () => {
                let params = { pin: acesso.config.pin }
                if (params.pin.length < 1) {
                    return false
                }
                $.post(acesso.uri + '/acesso/login', params, (response) => {
                    if(response.status) {
                        acesso.status = true
                        acesso.setor = response.group.nome_grupo_categoria
                        acesso.terminal_nome = response.nome
                        acesso.terminal_id = response.id
                    } else {
                        acesso.status = false
                    }
                })
            },
            validate: (card) => {

                if(!acesso.status) {
                    return false
                }

                $('#card').html('')
                $('#foto').src = ''
                $('#data_3').html('')
                let params = { card , terminal_id: acesso.terminal_id}
                $.post(acesso.uri + '/acesso/registro', params, (response) => {
                    console.log(response)
                    let data = response
                    const index = acesso.acao.findIndex(aa => aa.key === data.action)
                    $('#data_1').html(data.name)
                    if (index !== -1) {
                        $('#data_2').html(acesso.acao[index].value)
                    }
                    if (data.action == 'PS') {
                        $('#data_1').removeClass('bg-warning');
                        $('#data_1').removeClass('bg-danger');
                        $('#data_1').addClass('bg-success');
                    } else if (data.action == 'CR') {
                        $('#data_1').removeClass('bg-warning');
                        $('#data_1').removeClass('bg-success');
                        $('#data_1').addClass('bg-warning');
                        const date = data.hora_acesso
                        const readable_date = new Date(date).toLocaleString("pt-BR", {timeZone: 'America/Sao_Paulo'});
                        console.log(readable_date);
                        $('#data_2').html("Registro em " + readable_date);
                    } else {
                        $('#data_1').removeClass('bg-warning');
                        $('#data_1').removeClass('bg-success');
                        $('#data_1').addClass('bg-danger');
                    }
                    $('#card').html(data.name)
                    if(data.photo === null) {
                        $('#foto').attr('src','data:image/png;base64,' + acesso.person)
                    } else {
                        $('#foto').attr('src','data:image/png;base64,' + data.photo)
                    }
                    // $('#foto').src = 'data:image/png;base64,' + data.photo
                    $('#data_3').html(data.category)
                })

                // acesso.ws.sendData('VALIDATE', params, function (data) {
                
                // });
            },
            storage: {
                load: (name) => {
                    const rawValue = localStorage.getItem(name)
                    if (acesso.storage.isJson(rawValue)) {
                        return JSON.parse(rawValue)
                    } else {
                        return { rawValue }
                    }
                },
                save: (name, obj) => {
                    localStorage.setItem(name, JSON.stringify(obj))
                },
                delete: (name) => {
                    localStorage.removeItem(name)
                },
                isJson: function (str) {
                    try {
                        JSON.parse(str)
                    } catch (e) {
                        return false
                    }
                    return true
                }
            }
        }
        $(document).ready(function() {
            $('#card').focus()
            $('#card').select()
            $(document).on('click','#main',function () {
                $('#card').focus()
                $('#card').select()
            })

            acesso.init()
        })
    </script>
<?php $this->endsection(); ?>