<?php

namespace App\Validation;

class DatetimeRules
{
    public function date_format(?string $date, string $format = 'Y-m-d H:i:s')
    {
        if ($date) {
            $d = \DateTime::createFromFormat($format, $date);
            return $d && $d->format($format) == $date;
        }
        return false;
    }
}
