<?php

namespace App\RequestValidation;

class TicketValidation
{
    public const CREATE = [
        'event_id' => [
            'rules' => 'required|is_not_unique[eventos.id]',
            'errors' => [
                'required' => 'Informe um evento.',
                'is_not_unique' => 'Informe um evento (event_id) válido.',
            ],
        ],
        'category_id' => [
            'rules' => 'required|is_not_unique[categorias.id]',
            'errors' => [
                'required' => 'Informe uma categoria.',
                'is_not_unique' => 'Informe uma categoria (category_id) válida.',
            ],
        ],
        'ticket_number' => [
            'rules' => 'required|is_unique[cartoes.cartao]',
            'errors' => [
                'required' => 'Informe um ticket_number.',
                'is_unique' => 'ticket_number já existe! Informe um ticket_number não utilizado.',
            ],
        ],
        'status' => [
            'rules' => 'required|in_list[0,1]',
            'errors' => [
                'required' => 'Informe o status (0/1)',
            ],
        ],
        'master' => [
            'rules' => 'required|in_list[0,1]',
            'errors' => [
                'required' => 'Informe se é cartão mestre (0/1).',
            ],
        ]
    ];

    public const UPDATE = [
        'event_id' => [
            'rules' => 'required|is_not_unique[eventos.id]',
            'errors' => [
                'required' => 'Informe um evento.',
                'is_not_unique' => 'Informe um evento (event_id) válido.',
            ],
        ],
        'category_id' => [
            'rules' => 'required|is_not_unique[categorias.id]',
            'errors' => [
                'required' => 'Informe uma categoria.',
                'is_not_unique' => 'Informe uma categoria (category_id) válida.',
            ],
        ],
        'ticket_number' => [
            'rules' => 'required',
            'errors' => [
                'required' => 'Informe um ticket_number.',
            ],
        ],
        'status' => [
            'rules' => 'required|in_list[0,1]',
            'errors' => [
                'required' => 'Informe o status (0/1)',
            ],
        ],
        'master' => [
            'rules' => 'required|in_list[0,1]',
            'errors' => [
                'required' => 'Informe se é cartão mestre (0/1).',
            ],
        ]
    ];
}
