<?php

namespace App\RequestValidation;

class EventValidation
{
    public const CREATE = [
        'name' => [
            'rules' => 'required|min_length[4]',
            'errors' => [
                'required' => 'Informe um nome.',
                'min_length' => 'Informe um nome válido.',
            ],
        ],
        'local' => [
            'rules' => 'required',
            'errors' => [
                'required' => 'Informe um local.',
            ],
        ],
        'start_date' => [
            'rules' => 'required|date_format[Y-m-d H:i:s]',
            'errors' => [
                'required' => 'Informe a data de início.',
            ],
        ],
        'end_date' => [
            'rules' => 'required|date_format[Y-m-d H:i:s]',
            'errors' => [
                'required' => 'Informe a data de encerramento.',
            ],
        ]
    ];

    public const UPDATE = [
        'name' => [
            'rules' => 'required|min_length[4]',
            'errors' => [
                'required' => 'Informe um nome válido.',
                'min_length' => 'Informe um nome válido.',
            ],
        ]
    ];
}
