<?php

namespace App\RequestValidation;

class CategoryValidation
{
    public const CREATE = [
        'name' => [
            'rules' => 'required|min_length[4]',
            'errors' => [
                'required' => 'Informe um nome.',
                'min_length' => 'Informe um nome válido.',
            ],
        ],
        'multi_access' => [
            'rules' => 'required',
            'errors' => [
                'required' => 'informe se permite multiplo acesso.',
            ],
        ],
        'type' => [
            'rules' => 'required|in_list[TICKET,CREDENCIADO,COLABORADOR]',
            'errors' => [
                'required' => 'Informe um tipo.',
                'in_list' => 'Informe um tipo valido (TICKET,CREDENCIADO,COLABORADOR).',
            ],
        ]
    ];

    public const UPDATE = [
        'name' => [
            'rules' => 'required|min_length[4]',
            'errors' => [
                'required' => 'Informe um nome.',
                'min_length' => 'Informe um nome válido.',
            ],
        ],
        'multi_access' => [
            'rules' => 'required',
            'errors' => [
                'required' => 'informe se permite multiplo acesso.',
            ],
        ],
        'type' => [
            'rules' => 'required|in_list[TICKET,CREDENCIADO,COLABORADOR]',
            'errors' => [
                'required' => 'Informe um tipo.',
                'in_list' => 'Informe um tipo valido (TICKET,CREDENCIADO,COLABORADOR).',
            ],
        ]
    ];
}
