<?php

namespace App\Models;

use CodeIgniter\Model;

class TicketeiraEventoModel extends Model
{
    protected $DBGroup          = 'default';
    protected $table            = 'ticketeira_evento';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $insertID         = 0;
    protected $returnType       = 'object';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = [
        'id',
        'evento_id',
        'ticket_serial_id',
        'registry_serial_id',
        'entrega_serial_id',
        'ticketeira_id',
        'token',
        'identify',
        'params',
        'lastUpdate',
        'startSync',
        'endSync',
        'statusSync',
        'lastLog',
        'active',
    ];

    // Dates
    protected $useTimestamps = false;
    protected $beforeInsert = ['insertLastDate'];
    protected $beforeUpdate = ['updateLastDate'];

    public function getAllDetails()
    {
        return $this->select("
            ticketeira_evento.id,
            ticketeira_evento.ticketeira_id,
            ticketeira_evento.evento_id,
            ticketeira_evento.identify,
            ticketeira_evento.lastUpdate,
            ticketeira_evento.active,
            ticketeira_evento.ticket_serial_id,
            ticketeira_evento.registry_serial_id,
            ticketeira_evento.entrega_serial_id,
            eventos.evento,
            ticketeira.nome as ticketeira,
            ticketeira.modulo
        ")
            ->join('eventos', 'eventos.id = ticketeira_evento.evento_id', 'left')
            ->join('ticketeira', 'ticketeira.id = ticketeira_evento.ticketeira_id', 'left')
            ->orderBy('ticketeira_evento.lastUpdate', 'desc')
            ->get()->getResultObject();
    }

    protected function insertLastDate($data) {
        $data['data']['lastUpdate'] = date('Y-m-d H:i:s');
        return $data;
    }

    protected function updateLastDate($data) {
        $data['data']['lastUpdate'] = date('Y-m-d H:i:s');
        return $data;
    }

}
