<?php

namespace App\Models;

use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
use App\Models\LogDataModel;

class TicketModel extends Model
{
    protected $DBGroup          = 'default';
    protected $table            = 'cartoes';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $insertID         = 0;
    protected $returnType       = 'object';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = [
        'id',
        'serial_id',
        'servidor_id',
        'id_evento',
        'id_user',
        'id_categoria',
        'cartao',
        'nome',
        'email',
        'rg',
        'cpf',
        'situacao',
        'campoextra1',
        'campoextra2',
        'mestre',
        'remote_id',
        'send_on',
        'parent_id',
        'ticketeira_id',
        'updated_at',
        'ticketeira_identify',
        'ticketeira_values',
        'ticketeira_updated_at',
        'import_id'
    ];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'create_time';
    protected $updatedField  = 'updated_at';
    //protected $beforeUpdate   = ['logData'];

    public function getCredenciado($ticket)
    {
        return $this->select("
            cartoes.*
        ")
            ->join('categorias', 'categorias.id = cartoes.id_categoria', 'left')
            ->whereIn('categorias.tipo', ['CREDENCIADO', 'COLABORADOR'])
            ->where('cartoes.cartao', $ticket)
            ->get()->getFirstRow();
    }

    public function validaTicket($cartao, $terminalId)
    {
        $rs = $this->select("
            cartoes.cartao,
            cartoes.id,
            cartoes.nome,
            categorias.categoria,
            cartoes.id_evento,
            cartoes.situacao,
            cartoes.mestre,
            terminal.id as terminal_id,
            categorias.idr_multiplo,
            categorias.categoria,
            count(marcacao.id) as marcacao,
            max(marcacao.data_acesso) as hora_acesso,
            case when now() BETWEEN eventos.data_inicio and eventos.data_fim
                then 1
                else 0
            end as valido
        ")
            ->join('eventos', 'eventos.id = cartoes.id_evento', 'left')
            ->join('categorias', 'categorias.id = cartoes.id_categoria', 'left')
            ->join('marcacao', "marcacao.id_pessoa = cartoes.id and marcacao.acao = 'PS'", 'left')
            ->join('grupo_categoria_item', "grupo_categoria_item.id_categoria = categorias.id", 'left')
            ->join('grupo_categoria', "grupo_categoria.id = grupo_categoria_item.id_grupo_categoria", 'left')
            ->join('terminal', "terminal.grupo_categoria_id = grupo_categoria.id", 'left')
            ->where(new RawSql("trim( leading 0 from cartoes.cartao ) = trim( leading 0 from '{$cartao}' )"))
            ->where('terminal.id', $terminalId)
            ->groupBy('cartoes.cartao')
            ->get();

        return $rs->getFirstRow();
    }

    public function validaTicketPin($ticket, $pin)
    {
        $ticket = addslashes(trim((string) $ticket));
        $pin = addslashes(trim((string) $pin));
        $rs = $this->select("
            cartoes.cartao,
            cartoes.id,
            cartoes.nome,
            categorias.categoria,
            cartoes.id_evento,
            cartoes.situacao,
            cartoes.mestre,
            cartoes.credenciado_em,
            terminal.id as terminal_id,
            categorias.idr_multiplo,
            categorias.categoria,
            categorias.tipo,
            eventos.evento as evento,
            count(marcacao.id) as marcacao,
            max(marcacao.data_acesso) as hora_acesso,
            case when now() BETWEEN eventos.data_inicio and eventos.data_fim
                then 1
                else 0
            end as valido
        ")
            ->join('eventos', 'eventos.id = cartoes.id_evento', 'left')
            ->join('categorias', 'categorias.id = cartoes.id_categoria', 'left')
            ->join('marcacao', "marcacao.id_pessoa = cartoes.id and marcacao.acao = 'PS'", 'left')
            ->join('grupo_categoria_item', "grupo_categoria_item.id_categoria = categorias.id", 'left')
            ->join('grupo_categoria', "grupo_categoria.id = grupo_categoria_item.id_grupo_categoria", 'left')
            ->join('terminal', "terminal.grupo_categoria_id = grupo_categoria.id", 'left')
            ->where(new RawSql("trim( leading 0 from cartoes.cartao ) = trim( leading 0 from '{$ticket}' )"))
            ->where('terminal.terminal_pin', $pin)
            ->where('terminal.terminal_model', 'APP')
            ->groupBy('cartoes.cartao')
            ->get();

        return $rs->getFirstRow();
    }

    public function validaEntregaPin($ticket, $pin)
    {
        $ticket = addslashes(trim((string) $ticket));
        $pin = addslashes(trim((string) $pin));
        $rs = $this->select("
            cartoes.cartao,
            cartoes.id,
            cartoes.nome,
            categorias.categoria,
            cartoes.id_evento,
            cartoes.situacao,
            cartoes.mestre,
            cartoes.credenciado_em,
            terminal.id as terminal_id,
            categorias.idr_multiplo,
            categorias.categoria,
            categorias.tipo,
            eventos.evento as evento,
            count(entrega.id) as marcacao,
            max(entrega.data_acesso) as hora_acesso,
            1 as valido
        ")
            ->join('eventos', 'eventos.id = cartoes.id_evento', 'left')
            ->join('categorias', 'categorias.id = cartoes.id_categoria', 'left')
            ->join('entrega', "entrega.id_pessoa = cartoes.id and entrega.acao = 'PS'", 'left')
            ->join('grupo_categoria_item', "grupo_categoria_item.id_categoria = categorias.id", 'left')
            ->join('grupo_categoria', "grupo_categoria.id = grupo_categoria_item.id_grupo_categoria", 'left')
            ->join('terminal', "terminal.grupo_categoria_id = grupo_categoria.id", 'left')
            ->where(new RawSql("trim( leading 0 from cartoes.cartao ) = trim( leading 0 from '{$ticket}' )"))
            ->where('terminal.terminal_pin', $pin)
            ->where('terminal.terminal_model', 'ENTREGA')
            ->groupBy('cartoes.cartao')
            ->get();

        return $rs->getFirstRow();
    }

    public function setSituacao($ticketId)
    {
        $rs = $this->select("
                cartoes.id, cartoes.situacao, cartoes.master, fotos.id_pessoas
            ")
            ->join('fotos', 'fotos.id_pessoas = cartoes.id', 'left')
            ->where('cartoes.id', $ticketId)
            ->get()->getFirstRow();
        if ($rs) {
            if ($rs->mestre != 1) {
                if (!empty($rs->id_pessoas)) {
                    // not yet!
                }
            }
        }
    }

    public function addOrInsert($data, $serialId)
    {
        $dataOut = (object) [
            'id' => null,
            'exists' => null,
        ];
        $ticket = $this->where([
            'id_evento' => $data->id_evento,
            'cartao' => $data->cartao
        ])->first();

        if (!empty($ticket)) {
            $dataOut->id = $ticket->id;
            $dataOut->exists = true;
            if ((int) $ticket->situacao != (int)$data->situacao) {
                $this->update($ticket->id, [
                    'serial_id' => $serialId,
                    'campoextra1' => $data->campoextra1,
                    'campoextra2' => $data->campoextra2,
                    'email' => $data->email,
                    'nome' => $data->nome,
                    'updated_at' => date('Y-m-d H:i:s'),
                    'situacao' => $data->situacao
                ]);
            }
        } else {
            $dataOut->exists = false;
            $dataOut->id = $this->insert($data);
        }

        return $dataOut;
    }

    public function getNextSerialId()
    {
        $rs = $this->selectMax('serial_id')->first();
        if(empty($rs)) {
            return 1;
        } else {
            return (int) $rs->serial_id + 1;
        }
    }

    public function getDataIhx()
    {
        return $this->select('
                cartoes.id
                ,eventos.evento,
                ,eventos.data_inicio,
                ,cartoes.cartao  as codigoingresso
                ,categorias.categoria
                ,max(marcacao.data_acesso) as data_acesso
                ,cartoes.situacao as ativo
                ,cartoes.nome 
            ')
            ->join('categorias','categorias.id = cartoes.id_categoria','INNER')
            ->join('eventos','eventos.id = cartoes.id_evento','INNER')
            ->join('marcacao','marcacao.cartao = cartoes.cartao','LEFT')
            ->groupBy('cartoes.id');
    }

    protected function logData(array $data)
    {
        /*
        $logdata = new LogDataModel();
        //$oldData = $this->find($data['id'][0]);
        $newData = $data['data'];

        $log = [
            'type' => 'UPDATE',
            'table' => 'cartoes',
            'table_id' => $data['id'][0],
            'user_id' => $data['data']['id_user'],
           // 'old_data' => json_encode($oldData),
            'new_data' => json_encode($newData),
        ];
        
        $logdata->insert($log);
        */
        return $data;
    }
}
