<?php

namespace App\Models;

use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;

class RegistryModel extends Model
{
    protected $DBGroup          = 'default';
    protected $table            = 'marcacao';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $insertID         = 0;
    protected $returnType       = 'object';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = [
        'id',
        'serial_id',
        'id_pessoa',
        'id_evento',
        'cartao',
        'data_acesso',
        'hora_acesso',
        'acao',
        'terminal',
        'giro',
        'remote_id',
        'send_on'
    ];

    // Dates
    protected $useTimestamps = false;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];

    public function getAcoes()
    {
        return [
            'PS' => (object)['info' => 'Ticket Registrado', 'style' => 'success'],
            'CB' => (object)['info' => 'Ticket Bloqueado', 'style' => 'danger'],
            'CR' => (object)['info' => 'Ticket Já registrado', 'style' => 'warning'],
            'CE' => (object)['info' => 'Evento Expirado', 'style' => 'danger'],
            'CI' => (object)['info' => 'Ticket Inválido', 'style' => 'danger'],
            'EG' => (object)['info' => 'Esperando Giro', 'style' => 'secundary'],
            'EX' => (object)['info' => 'Entrada não efetuada', 'style' => 'danger'],
        ];
    }

    public function getAction($action)
    {
        return $this->getAcoes()[$action];
    }

    public function getNextSerialId()
    {
        $rs = $this->selectMax('serial_id')->first();
        if(empty($rs)) {
            return 1;
        } else {
            return (int) $rs->serial_id + 1;
        }
    }

    public function getRegistry($ticketId)
    {
        return $this->select("
            marcacao.id,
            marcacao.data_acesso,
            marcacao.acao,
            marcacao.terminal,
            terminal.terminal_model,
            terminal.terminal_nome,
            marcacao.giro
        ")
            ->join('terminal', 'terminal.id = marcacao.terminal', 'left')
            ->where('marcacao.id_pessoa', $ticketId)
            ->orderBy('marcacao.id', 'desc')
            ->limit(100)
            ->get()->getResultObject();
    }

    public function getMonitor($id = null)
    {
        $rs = $this->select("
            marcacao.id as uid,
            cartoes.id as cid,
            marcacao.data_acesso,
            marcacao.acao,
            terminal.terminal_nome,
            cartoes.nome as nome_pessoa,
            categorias.categoria,
            eventos.evento,
            TIMESTAMPDIFF(MINUTE,marcacao.data_acesso,NOW())  as diftime
        ")
            ->join('terminal', 'terminal.id = marcacao.terminal', 'left')
            ->join('cartoes', 'cartoes.id = marcacao.id_pessoa', 'left')
            ->join('categorias', 'categorias.id = cartoes.id_categoria', 'left')
            ->join('eventos', 'eventos.id = cartoes.id_evento', 'left')
            // ->where('categorias.tipo', 'CREDENCIADO')
            ->where(new RawSql('TIMESTAMPDIFF(MINUTE,marcacao.data_acesso,NOW()) < 2'))
            ->orderBy('marcacao.data_acesso', 'desc')
            ->limit(1);
        if (!empty($id)) {
            $rs->where('terminal.id', $id);
        }
        return $rs->get()->getResultObject();
    }
    public function getPublico($params=[])
    {
        $rs = $this->select("
            count(DISTINCT cartoes.id) as qtd
        ")
        ->join('cartoes', 'cartoes.id = marcacao.id_pessoa', 'left')
        ->join('categorias', 'categorias.id = cartoes.id_categoria', 'left')
        ->join('eventos', 'eventos.id = cartoes.id_evento', 'left')
        ->where('marcacao.acao', 'PS')
        ->where('categorias.tipo', 'TICKET')
        ->where(new RawSql('now() BETWEEN eventos.data_inicio and eventos.data_fim'));

        if(array_key_exists('startDate', $params)) {
            $startDate = date('Y-m-d H:i:s', strtotime($params['startDate']));
            $rs->where(new RawSql("marcacao.data_acesso >= '{$startDate}'"));
        }
        
        if(array_key_exists('endDate', $params)) {
            $endDate = date('Y-m-d H:i:s', strtotime($params['endDate']));
            $rs->where(new RawSql("marcacao.data_acesso <= '{$endDate}'"));
        }

        return $rs->get()->getFirstRow();
    }

    public function addOnlyRegistry($ticketId, $dateTimeAcesso)
    {
        $registry = $this->where([
            'id_pessoa' => $ticketId,
            'acao' => 'PS',
            'data_acesso' => date('Y-m-d H:i:s', strtotime($dateTimeAcesso)),
        ])->first();
        
        if(empty($registry)) {
            $ticket = $this->db
                ->table('cartoes')
                ->where('id', $ticketId)
                ->get()->getResultObject();
            
            if(!empty($ticket)) {
                $data = [
                    'id_pessoa' => $ticket[0]->id,
                    'id_evento' => $ticket[0]->id_evento,
                    'cartao' => $ticket[0]->cartao,
                    'data_acesso' => date('Y-m-d H:i:s', strtotime($dateTimeAcesso)),
                    'acao' => 'PS',
                    'terminal' => '1',
                    'giro',
                    'remote_id',
                    'send_on' => date('Y-m-d H:i:s')
                ];
                $this->insert($data);
            }
        }
    }

    public function getUnsendedRegister($idTicketeira, $limit)
    {
        return $this
            ->select(
                '   marcacao.id as id,
                    eventos.code as code,
                    marcacao.cartao as ticket_number,
                    marcacao.data_acesso as access_date,
                    marcacao.acao as action,
                    marcacao.terminal as terminal'
            )
            ->join('cartoes', 'cartoes.id = marcacao.id_pessoa')
            ->join('eventos', 'eventos.id = cartoes.id_evento')
            ->orderBy('marcacao.id', 'asc')
            ->where([
                'marcacao.send_on' => null,
               // 'cartoes.ticketeira_id' => $idTicketeira
            ])->findAll($limit);
    }

    public function getCount($idTicketeira)
    {
        return $this
            ->select(
                'count(DISTINCT marcacao.id) as qtd'
            )
            ->join('cartoes', 'cartoes.id = marcacao.id_pessoa')
            ->where([
                'marcacao.send_on' => null,
               // 'cartoes.ticketeira_id' => $idTicketeira
            ])->get()->getFirstRow();
    }

}
