<?php

namespace App\Models;

use CodeIgniter\Model;

class PhotoModel extends Model
{
    protected $DBGroup          = 'default';
    protected $table            = 'fotos';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $insertID         = 0;
    protected $returnType       = 'object';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = [
        'id',
        'id_pessoas',
        'foto',
        'foto_mini',
        'fotostr',
        'image',
        'send_on',
        'remote_id',
        'criado_em'
    ];

    // Dates
    protected $useTimestamps = false;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'criado_em';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $afterInsert    = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];

    protected $beforeInsert = ['processaInsert'];
    protected $beforeUpdate = ['processaUpdate'];

    protected function processaInsert($data) {
        if(!array_key_exists('criado_em', $data['data']) || empty($data['data']['criado_em'])) {
            $data['data']['criado_em'] = date('Y-m-d H:i:s');
        }
        return $data;
    }

    protected function processaUpdate($data) {

        if (is_array($data) && array_key_exists('data', $data) && (!array_key_exists('criado_em', $data['data']) || empty($data['data']['criado_em']))) {
            $data['data']['criado_em'] = date('Y-m-d H:i:s');
        }

        return $data;
    }
}
