<?php

namespace App\Models;

use CodeIgniter\Model;

class ParamModel extends Model
{
    protected $DBGroup          = 'default';
    protected $table            = 'parametro';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $insertID         = 0;
    protected $returnType       = 'object';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = [
        'id',
        'param_name',
        'param_value',
        'param_desc',
        'param_type',
    ];

    public function getParamByName($paramName)
    {
        $param = $this->where('param_name', $paramName)->first();
        if ($param) {
            if ($param->param_type == 'JSON') {
                return json_decode($param->param_value);
            } else {
                return $param->param_value;
            }
        }
        return null;
    }

    public function setParamByName($paramName, $paramValue, $paramType = 'JSON')
    {
        $param = $this->where('param_name', $paramName)->first();
        if ($param) {
            return $this->update($param->id, [
                'param_value' => $paramValue
            ]);
        } else {
            return $this->save([
                'param_name' => $paramName,
                'param_value' => $paramValue,
                'param_type' => $paramType,
            ]);
        }
    }
}
