<?php

namespace App\Models;

use CodeIgniter\Model;

class ImportTicketModel extends Model
{
    protected $DBGroup          = 'default';
    protected $table            = 'import_ticket';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $insertID         = 0;
    protected $returnType       = 'object';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = [
        'id',
        'import_data_id',
        'ticketeira_id',
        'event_id',
        'remote_id',
        'ticket_id',
        'data_import_category_id',
        'code',
        'name',
        'email',
        'cpf',
        'rg',
        'campoextra1',
        'campoextra2',
        'checkin_at',
        'created_at',
        'updated_at',
        'active',
        'merged'
    ];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
   
}
