<?php

namespace App\Models\Ihx;

use CodeIgniter\Model;

class IhxTipoIngressoModel extends Model
{
    protected $DBGroup          = 'ihx';
    protected $table            = 'evt_tipoingresso';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $insertID         = 0;
    protected $returnType       = 'object';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = [
        'id',
        'descricao',
        'dateinsert',
        'dateupdate'
    ];

    protected $useTimestamps = false;
    protected $beforeInsert   = ['dates'];
    
    protected function dates($data)
    {
        $data['data']['dateinsert'] = date('Y-m-d H:i:s');
        $data['data']['dateupdate'] = date('Y-m-d H:i:s');
        return $data;
    }

    public function addTipo($descricao)
    {
        $rs = $this->where([
            'descricao' => $descricao
        ])->first();

        if (!$rs) {
            return $this->insert([
                'descricao'=>$descricao
            ]);
        } else {
            return $rs->id;
        }
    }
}
