<?php

namespace App\Models\Ihx;

use CodeIgniter\Model;

class IhxServiceModel extends Model
{
    protected $DBGroup          = 'ihx';
    protected $table            = 'service';
    protected $primaryKey       = 'name';
    protected $useAutoIncrement = true;
    protected $insertID         = 0;
    protected $returnType       = 'object';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = [
        'name',
        'active',
        'started_on',
        'last_proccess',
        'finished_on',
        'status',
        'log'
    ];

    protected $useTimestamps = false;

    public function initService($name) {
        $rs = $this->where(['name' => $name])->first(); 
        if($rs) {
            $this->update($rs->name, [
                'active' => 1,
                'started_on' => date('Y-m-d H:i:s'),
                'last_proccess' => date('Y-m-d H:i:s'),
                'status' => 1,
                'log' => null,
            ]);
        } else {
            $this->insert([
                'name' =>$name,
                'active' => 1,
                'started_on' => date('Y-m-d H:i:s'),
                'last_proccess' => date('Y-m-d H:i:s'),
                'status' => 1,
                'log' => null,
            ]);
        }
    }

    public function getStatus($name) {
        $rs = $this->where(['name' => $name])->first();
    }
}
