<?php

namespace App\Models\Ihx;

use CodeIgniter\Model;

class IhxRotaModel extends Model
{
    protected $DBGroup          = 'ihx';
    protected $table            = 'rota';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $insertID         = 0;
    protected $returnType       = 'object';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = [
        'id',
        'rotadescricao',
        'dateinsert',
        'dateupdate',
        'palavras_chave'
    ];

    protected $useTimestamps = false;
    protected $beforeInsert   = ['dates'];

    protected function dates($data)
    {
        $data['data']['dateinsert'] = date('Y-m-d H:i:s');
        $data['data']['dateupdate'] = date('Y-m-d H:i:s');
        return $data;
    }

    public function addRota($rotadescricao)
    {
        $rs = $this->where([
            'rotadescricao' => $rotadescricao
        ])->first();

        if (empty($rs)) {
            $rs = $this->getRotaByWordKey($rotadescricao);
        }

        if (!$rs) {
            return $this->insert([
                'rotadescricao' => $rotadescricao
            ]);
        } else {
            return $rs->id;
        }
    }

    /**
     * Pesquisa rota por palavra chave
     * 
     */
    public function getRotaByWordKey($rotadescricao)
    {
        if (empty(trim((string) $rotadescricao))) {
            return null;
        }

        $rsAll = $this->findAll();
        foreach ($rsAll as $v) {
            if (empty($v->palavras_chave)) {
                continue;
            }
            $words = explode(',', $v->palavras_chave);
            foreach ($words as $word) {
                if (str_contains($rotadescricao, trim((string) $word))) {
                    return $v;
                }
            }
        }

        return null;
    }
}
