<?php

namespace App\Models\Ihx;

use CodeIgniter\Database\RawSql;
use CodeIgniter\Model;

class IhxIngressoModel extends Model
{
    protected $DBGroup          = 'ihx';
    protected $table            = 'evt_ingresso';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $insertID         = 0;
    protected $returnType       = 'object';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = [
        'id',
        'evento_id',
        'codigoingresso',
        'evt_sympla_ticket_number',
        'evt_sympla_sended_on',
        'evt_sympla_id',
        'area_id',
        'tipoingresso_id',
        'acessotipocontrolador',
        'dtevento',
        'utilizado',
        'identificacao',
        'ativo',
        'lote',
        'coletar'
    ];

    protected $useTimestamps = false;
    protected $beforeInsert   = ['defaults'];

    protected function defaults($data)
    {
        $data['data']['acessotipocontrolador'] = 8;
        // $data['data']['lote'] = 'UNICO';
        return $data;
    }

    public function iniciaSts()
    {
        $this->db->query('
            update evt_ingresso set 
                sts_import = 0
            where evt_sympla_id is not null
            ');
       
    }

    public function finalizaSts()
    {
        
        $this->db->query('
            update evt_ingresso set 
                ativo = 0,
                sts_import = 1
            where evt_sympla_id is not null
                and sts_import = 0
            ');
    }

    public function validaTicket($codigoIngresso, $pin)
    {
        return $this->select('
            evt_ingresso.id as ticketId,
            evt_ingresso.codigoingresso  as ticketNumber,
            evt_ingresso.ativo as situacao,
            evt_ingresso.utilizado as marcacao,
            equipamento.id as deviceId,
            equipamento.equipamentotipoterminal,
            equipamento.equipamentodescricao,
            equipamento.equipamentotcpip,
            equipamento.equipamentomacaddress,
            equipamento.equipamentoserverhost,
            evt_ingresso.evento_id as eventId,
            evt_evento.nome as eventName,
            evt_evento.empresa_id,
            setor.estruturaid_id,
            setor.id as setor_id,
            setor.setordescricao,
            null as valid,
            null as photo,
            evt_ingresso.lote as name,
            evt_tipoingresso.descricao  as category,
            max(acesso.acessodatahora) as hora_acesso
        ')
            ->join('rota', 'rota.id = evt_ingresso.area_id ', 'inner')
            ->join('rota_setor', 'rota_setor.rotaid_id = rota.id ', 'inner')
            ->join('setor', 'setor.id = rota_setor.setorid_id ', 'inner')
            ->join('equipamento', 'equipamento.setorid_id = setor.id ', 'inner')
            ->join('evt_evento', 'evt_evento.id = evt_ingresso.evento_id ', 'inner')
            ->join('evt_tipoingresso', 'evt_tipoingresso.id = evt_ingresso.tipoingresso_id ', 'inner')
            ->join('acesso', 'trim( leading 0 from acesso.cracha ) = trim( leading 0 from evt_ingresso.codigoingresso )', 'left')
            ->where([
                'equipamento.equipamentopatrimonio' => $pin,
            ])
            ->where(new RawSql("trim( leading 0 from evt_ingresso.codigoingresso ) = trim( leading 0 from '{$codigoIngresso}' )"))
            ->first();
    }

    public function addOrInsert($data)
    {
        $rs = $this->where(['codigoingresso' => $data->codigoingresso])->first();
        if (!$rs) {
            $this->insert($data);
            return 1;
        } else {
            $dataUpdate = [
                'utilizado' => (int) $data->utilizado,
                'ativo' => (int) $data->ativo,
                'sts_import' => 1,
            ];
            $this->update($rs->id, $dataUpdate);
        }
        return null;
    }


    public function merge($data)
    {
        $rs = $this->where(['codigoingresso' => $data->codigoingresso])->first();
        $update = [];
        if (!$rs) {
            return $this->insert($data);
        } else {
            if ($data->utilizado == 1 && $rs->utilizado != 1) {
                $update[] = ['utilizado' => 1];
            }

            if ((int) $data->ativo != (int) $rs->ativo) {
                $update[] = ['ativo' => (int) $rs->ativo];
            }

            if (!empty($update)) {
                $this->update($rs->id, $update);
            }
            return $rs->id;
        }
    }

    public function checkout($codigoingresso)
    {
        $rs = $this->like('codigoingresso' ,$codigoingresso)->first();
        if (!empty($rs)) {
            $this->update($rs->id, ['utilizado' => 1]);
        }
    }



    public function cancela($evtSymplaId)
    {
        $rs = $this->where(['evt_sympla_id' => $evtSymplaId])->first();
        if (!$rs) {
            return null;
        } else {
            if ($rs->ativo == 1) {
                $this->update($rs->id, ['ativo' => 0]);
                return 1;
            }
        }
        return null;
    }

    public function resume()
    {
        $builder = $this->db->table('evt_ingresso');
        $builder->select('
            count(*) as totalIngressos,
            sum(case when ativo = 1 then 1 else 0 end) as ativos,
            sum(case when ativo <> 1 then 1 else 0 end) as inativos,
            sum(case when utilizado = 1 then 1 else 0 end) as utilizados,
            sum(case when utilizado <> 1 then 1 else 0 end) as naoutilizados,
            sum(case when evt_sympla_sended_on is not null then 1 else 0 end) as symplasync
        ');
        return $builder->get()->getResult();
    }
    public function publico()
    {
        $builder = $this->db->table('evt_ingresso');
        $builder->select('
            count(*) as totalIngressos,
            sum(case when ativo = 1 then 1 else 0 end) as ativos,
            sum(case when ativo <> 1 then 1 else 0 end) as inativos,
            sum(case when utilizado = 1 then 1 else 0 end) as utilizados,
            sum(case when utilizado <> 1 then 1 else 0 end) as naoutilizados,
            sum(case when evt_sympla_sended_on is not null then 1 else 0 end) as symplasync
        ');
        if (time() >= strtotime('2023-01-29 10:00:00')) {
            $dataEvento = '2023-01-29 15:00:00';
        } else {
            $dataEvento = '2023-01-28 15:00:00';
        }
        $builder->where('dtevento >=', $dataEvento);
        return $builder->get()->getResult();
    }
}
