<?php

namespace App\Models;

use CodeIgniter\Model;

class GroupItemModel extends Model
{
    protected $DBGroup          = 'default';
    protected $table            = 'grupo_categoria_item';
    protected $primaryKey       = ['id_grupo_categoria','id_categoria'];
    protected $returnType       = 'object';
    protected $useSoftDeletes   = false;
    protected $protectFields    = false;
    protected $allowedFields    = [
        'id_grupo_categoria',
        'id_categoria'
    ];

    public function getCategoriesByGroup(int $group_id) {
        $query = "select
                        c.id,
                        c.categoria,
                        case when gci.id_grupo_categoria is not null then 1 else 0 end as active
                    from categorias c
                    left join grupo_categoria_item gci
                        on gci.id_categoria = c.id
                        and gci.id_grupo_categoria = {$group_id}
                    group by c.id";
        return $this->db->query($query)->getResult();
    }

    public function removeAll() {
        return $this->db->query('delete from grupo_categoria_item');
    }
}
