<?php

namespace App\Models;

use CodeIgniter\Model;

class DeviceModel extends Model
{
    protected $DBGroup          = 'default';
    protected $table            = 'terminal';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $insertID         = 0;
    protected $returnType       = 'object';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = [
        'id',
        'terminal_pin',
        'terminal_id',
        'terminal_ip',
        'terminal_cfg',
        'terminal_model',
        'terminal_nome',
        'terminal_plataform',
        'ativo',
        'grupo_categoria_id',
        'create_time',
    ];

    // Dates
    protected $useTimestamps = false;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'create_time';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];

    public function getDevices()
    {
        return $this->select("
            terminal.id,
            terminal.terminal_pin,
            terminal.terminal_id,
            terminal.terminal_model,
            terminal.terminal_nome,
            terminal.terminal_plataform,
            terminal.ativo,
            terminal.grupo_categoria_id,
            grupo_categoria.nome_grupo_categoria as grupo,
            terminal.create_time,
        ")
        ->join('grupo_categoria', 'grupo_categoria.id = terminal.grupo_categoria_id', 'left')
        ->orderBy('terminal.terminal_nome', 'asc')
        ->get()->getResultObject();
    }

    public function getDevicesCredenciados()
    {
        return $this->select("
            terminal.id
            ,terminal.terminal_ip
            ,terminal.terminal_nome
        ")
        ->join('grupo_categoria', 'grupo_categoria.id = terminal.grupo_categoria_id', 'left')
        ->join('grupo_categoria_item', 'grupo_categoria_item.id_grupo_categoria = grupo_categoria.id', 'left')
        ->join('categorias', 'categorias.id = grupo_categoria_item.id_categoria', 'left')
        ->orderBy('terminal.terminal_nome', 'asc')
        ->where([
            'terminal.ativo'=>'Y'
        ])
        ->whereIn('terminal.terminal_model', ['CATRACA', 'APP'])
        ->groupBy('terminal.id')
        ->get()->getResultObject();
    }

    public function types()
    {
        return [
            'CATRACA',
            'TABLET',
            'APP',
            'ENTREGA',
            'IHX-APP',
            'OUTROS'
        ];
    }

}
