<?php

namespace App\Models;

use CodeIgniter\Model;

class CategoryModel extends Model
{
    protected $DBGroup          = 'default';
    protected $table            = 'categorias';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $insertID         = 0;
    protected $returnType       = 'object';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = [
        'id',
        'code',
        'categoria',
        'idr_multiplo',
        'fluxo',
        'tipo',
        'external_id'
    ];

    public function getCategories() {
        $query = "select
                    categorias.id,
                    categorias.categoria,
                    categorias.idr_multiplo,
                    categorias.fluxo,
                    categorias.tipo,
                    count(cartoes.id) as tickets
                from categorias 
                left join cartoes 
                    on cartoes.id_categoria = categorias.id
                group by categorias.id";
        return $this->db->query($query)->getResult();
    }

    public function getTypes()
    {
        return  [
            'TICKET',
            'CREDENCIADO',
            'COLABORADOR'
        ];
    }

    public function getOrAdd($categoryName)
    {
        $category = $this->where(
            'categoria', trim((string) $categoryName)
        )->first();

        if(!empty($category)) {
            return $category->id;
        } else {
            return $this->insert([
                'categoria' => $categoryName,
                'idr_multiplo' => 0,
                'fluxo' => 0,
                'tipo' => 'TICKET'
            ]);
        }
    }
}
